# ilreaders-config.cmake.in


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was ilreaders-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/ilreaders-config.cmake")

# Define the include directory for the project
set(MY_PROJECT_INCLUDE_DIRS "${CMAKE_INSTALL_PREFIX}/include")

# Define the libraries for the project
set(MY_PROJECT_LIBRARIES IL::ilreaders)

# Make the variables available to the parent scope
set(MyProject_INCLUDE_DIRS "${MY_PROJECT_INCLUDE_DIRS}" CACHE INTERNAL "")
set(MyProject_LIBRARIES "${MY_PROJECT_LIBRARIES}" CACHE INTERNAL "")

