#include "utils.h"

#include <fstream>
#include <iostream>
#include <sstream>

const char* kNoAccessStr = "никогда";
const char* kKeyAAccessStr = "Ключ А";
const char* kKeyBAccessStr = "Ключ Б";
const char* kKeyAorBAccessStr = "Ключ А или Б";

std::filesystem::path GetAppDir() {
    std::filesystem::path s;
    char szCfgPath[PATH_MAX];
    auto count = readlink("/proc/self/exe", szCfgPath, std::size(szCfgPath) - 1);
    szCfgPath[count] = '\0';
    s = szCfgPath;
    return s.remove_filename();
}

std::string TemicPasswordToString(const int64_t& nPassword) {
    if (-1 == nPassword)
        return std::string();
    char szBuf[48];
    auto c = snprintf(szBuf, std::size(szBuf), "%.8x", (uint)nPassword);
    if (c <= 0)
        return std::string();
    return std::string(szBuf, c);
}

bool TryParseTemicPassword(const char* pStr, int64_t& nPassword) {
    char* p = nullptr;
    errno = 0;
    auto n = strtoll(pStr, &p, 16);
    if ((errno != 0) || (p == pStr))
        return false;
    nPassword = n;
    return true;
}

ssize_t FindTemicPassword(const CTemicPasswordList& oPasswords, uint nPassword) {
    for (auto it = oPasswords.cbegin(); it != oPasswords.cend(); it++)
        if (it->m_nPassword == nPassword)
            return std::distance(oPasswords.cbegin(), it);
    return -1;
}

std::filesystem::path GetTemicPasswordsFilePath() {
    return GetAppDir().append("temic_passwords.txt");
}

std::filesystem::path GetMcKeysFilePath() {
    return GetAppDir().append("mf_classic_keys.txt");
}

ssize_t FindMcKey(const CMcKeyList& oKeys, const int64_t& nKey) {
    for (auto it = oKeys.cbegin(); it != oKeys.cend(); it++)
        if (it->m_Key == nKey)
            return std::distance(oKeys.cbegin(), it);
    return -1;
}

std::filesystem::path GetMpKeysFilePath() {
    return GetAppDir().append("mf_plus_keys.txt");
}

// void LoadMpKeysFromFile(const std::filesystem::path& path, CMpKeyList& oKeys) {
//     if (std::filesystem::exists(path)) {
//         std::ifstream inFile;
//         inFile.open(path);
//         inFile >> std::hex;
//         CMpKeyInfo r;
//         while (true) {
//             inFile >> r.m_Key.ll.hi >> r.m_Key.ll.lo >> std::quoted(r.m_sComment);
//             if (!inFile.good())
//                 break;
//             oKeys.emplace_back(std::move(r));
//         }
//     }
// }

// void SaveMpKeysToFile(const std::filesystem::path& path, const CMpKeyList& oKeys) {
//     std::ofstream outFile;
//     outFile.open(path);
//     outFile.imbue(std::locale("C"));
//     outFile << std::hex;
//     for (auto& r : oKeys) {
//         outFile << r.m_Key.ll.hi << '\t' << r.m_Key.ll.lo << '\t' << std::quoted(r.m_sComment)
//                 << std::endl;
//     }
// }

ssize_t FindMpKey(const CMpKeyList& oKeys, const ilr_mf_plus_key& Key) {
    for (auto it = oKeys.cbegin(); it != oKeys.cend(); it++)
        if (it->m_Key == Key)
            return std::distance(oKeys.cbegin(), it);
    return -1;
}

bool CanMfWriteKeyA(uint nTrailerAreaAccess, bool fAuthKeyB) {
    return fAuthKeyB ? ((1 == nTrailerAreaAccess) || (6 == nTrailerAreaAccess)) :
                       ((0 == nTrailerAreaAccess) || (4 == nTrailerAreaAccess));
}

// bool CanMfReadAccessBits(uint nTrailerAreaAccess, bool fAuthKeyB) {
//     return fAuthKeyB ? ((1 == nTrailerAreaAccess) || (3 == nTrailerAreaAccess) ||
//                         ((nTrailerAreaAccess >= 5) && (nTrailerAreaAccess <= 7))) :
//                        true;
// }

bool CanMfWriteAccessBits(uint nTrailerAreaAccess, bool fAuthKeyB) {
    return fAuthKeyB ? ((5 == nTrailerAreaAccess) || (6 == nTrailerAreaAccess)) :
                       (4 == nTrailerAreaAccess);
}

bool CanMfReadKeyB(uint nTrailerAreaAccess, bool fAuthKeyB) {
    return fAuthKeyB ? false :
                       ((0 == nTrailerAreaAccess) || (2 == nTrailerAreaAccess) ||
                        (4 == nTrailerAreaAccess));
}

bool CanMfWriteKeyB(uint nTrailerAreaAccess, bool fAuthKeyB) {
    return fAuthKeyB ? ((1 == nTrailerAreaAccess) || (6 == nTrailerAreaAccess)) :
                       ((0 == nTrailerAreaAccess) || (4 == nTrailerAreaAccess));
}

bool CanMfReadUserData(uint nUserDataAreaAccess, bool fAuthKeyB) {
    return fAuthKeyB ? (nUserDataAreaAccess <= 6) : (nUserDataAreaAccess <= 4);
}

bool CanMfWriteUserData(uint nUserDataAreaAccess, bool fAuthKeyB) {
    return fAuthKeyB ? ((nUserDataAreaAccess <= 1) || (3 == nUserDataAreaAccess) ||
                        (6 == nUserDataAreaAccess)) :
                       (0 == nUserDataAreaAccess);
}

bool CanMfIncrementUserData(uint nUserDataAreaAccess, bool fAuthKeyB) {
    return fAuthKeyB ? ((0 == nUserDataAreaAccess) || (6 == nUserDataAreaAccess)) :
                       (0 == nUserDataAreaAccess);
}

bool CanMfDtrUserData(uint nUserDataAreaAccess, bool fAuthKeyB) {
    return ((0 == nUserDataAreaAccess) || (3 == nUserDataAreaAccess) || (4 == nUserDataAreaAccess));
}
