#include "CReaderMpKeysDialog.h"

// #include <iostream>

#define HAS_STYLE_PROVIDER_ADD_PROVIDER_FOR_DISPLAY GTKMM_CHECK_VERSION(4, 9, 1)

CReaderMpKeysDialog::CReaderMpKeysDialog() :
    m_fModifed(false),
    m_nChangedKeys(0),
    m_VBox(Gtk::Orientation::VERTICAL),
    m_WriteAllButton("Записать все"),
    m_CancelButton("Отмена"),
    m_OkButton("OK") {
    set_destroy_with_parent(true);

    set_title("Ключи Mifare Plus считывателя");
    set_default_size(700, 700);

    m_VBox.set_margin(5);
    m_VBox.set_expand();
    set_child(m_VBox);
    m_VBox.append(m_Notebook);
    m_VBox.append(m_BottomBox);

    m_Notebook.set_margin(10);
    m_Notebook.set_expand();
    m_Notebook.set_expand();
    m_Notebook.append_page(m_aScrolledWindow[0], "Ключи А");
    m_Notebook.append_page(m_aScrolledWindow[1], "Ключи Б");
    for (size_t i = 0; i < std::size(m_aScrolledWindow); i++) {
        auto& oColumnView = m_aColumnView[i];
        m_aScrolledWindow[i].set_child(oColumnView);
        m_aListStore[i] = Gio::ListStore<ModelColumns>::create();

        // Set list model and selection model.
        auto selection_model = Gtk::SingleSelection::create(m_aListStore[i]);
        selection_model->set_autoselect(false);
        selection_model->set_can_unselect(true);
        oColumnView.set_model(selection_model);
        oColumnView.add_css_class("data-table");  // high density table

        // Add the ColumnView's columns:

        // Столбец "№"
        auto factory = Gtk::SignalListItemFactory::create();
        factory->signal_setup().connect(
            sigc::mem_fun(*this, &CReaderMpKeysDialog::on_setup_checkbutton));
        factory->signal_bind().connect(sigc::mem_fun(*this, &CReaderMpKeysDialog::on_bind_idx));
        auto column = Gtk::ColumnViewColumn::create("№", factory);
        oColumnView.append_column(column);

        // Столбец "Ключ"
        factory = Gtk::SignalListItemFactory::create();
        factory->signal_setup().connect(sigc::mem_fun(*this, &CReaderMpKeysDialog::on_setup_key));
        factory->signal_bind().connect(sigc::mem_fun(*this, &CReaderMpKeysDialog::on_bind_key));
        column = Gtk::ColumnViewColumn::create("Ключ", factory);
        oColumnView.append_column(column);

        // Столбец "Комментарий"
        factory = Gtk::SignalListItemFactory::create();
        factory->signal_setup().connect(
            sigc::mem_fun(*this, &CReaderMpKeysDialog::on_setup_comment));
        factory->signal_bind().connect(sigc::mem_fun(*this, &CReaderMpKeysDialog::on_bind_comment));
        column = Gtk::ColumnViewColumn::create("Комментарий", factory);
        oColumnView.append_column(column);
    }

    // Load extra CSS file.
    m_refCssProvider = Gtk::CssProvider::create();
#if HAS_STYLE_PROVIDER_ADD_PROVIDER_FOR_DISPLAY
    Gtk::StyleProvider::add_provider_for_display(get_display(), m_refCssProvider,
                                                 GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#else
    Gtk::StyleContext::add_provider_for_display(get_display(), m_refCssProvider,
                                                GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#endif
    std::string sCSS =
        ".key {"
        "  font-family:monospace; "
        "}"
        ".changed {"
        "  font-weight:bold;"
        "}";
    m_refCssProvider->load_from_data(sCSS);

    m_BottomBox.set_margin(5);
    m_BottomBox.set_spacing(5);
    m_BottomBox.set_hexpand();
    m_BottomBox.set_halign(Gtk::Align::END);
    m_BottomBox.append(m_WriteAllButton);
    m_BottomBox.append(m_CancelButton);
    m_BottomBox.append(m_OkButton);

    m_WriteAllButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CReaderMpKeysDialog::on_button_writeall));
    m_CancelButton.set_halign(Gtk::Align::END);
    m_OkButton.set_halign(Gtk::Align::END);
    m_CancelButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CReaderMpKeysDialog::on_button_cancel));
    m_OkButton.signal_clicked().connect(sigc::mem_fun(*this, &CReaderMpKeysDialog::on_button_ok));

    set_default_widget(m_OkButton);
}

CReaderMpKeysDialog::~CReaderMpKeysDialog() {
}

void CReaderMpKeysDialog::Init(const ilr::CReader& oReader,
                               Glib::RefPtr<CMifareReaderSettings> refSettings) {
    m_oReader = oReader.Clone();
    m_refSettings = refSettings;
    m_fModifed = false;
    if (m_oReader) {
        UpdateView(false);
        UpdateView(true);
    }
}

void CReaderMpKeysDialog::on_setup_checkbutton(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    list_item->set_child(*Gtk::make_managed<Gtk::CheckButton>());
}

void CReaderMpKeysDialog::on_setup_key(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto pLabel = Gtk::make_managed<Gtk::EditableLabel>();
    list_item->set_child(*pLabel);
    pLabel->add_css_class("key");
    pLabel->set_max_width_chars(12);
    pLabel->property_editing().signal_changed().connect(sigc::bind(
        sigc::mem_fun(*this, &CReaderMpKeysDialog::on_key_label_editing_change), list_item.get()));
}

void CReaderMpKeysDialog::on_setup_comment(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto pLabel = Gtk::make_managed<Gtk::EditableLabel>();
    pLabel->property_editing().signal_changed().connect(
        sigc::bind(sigc::mem_fun(*this, &CReaderMpKeysDialog::on_comment_label_editing_change),
                   list_item.get()));
    list_item->set_child(*pLabel);
}

void CReaderMpKeysDialog::on_bind_idx(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto checkButton = dynamic_cast<Gtk::CheckButton*>(list_item->get_child());
    if (!checkButton)
        return;
    checkButton->set_label(Glib::ustring::format(col->m_nIdx));
    Glib::Binding::bind_property(
        col->m_property_check.get_proxy(), checkButton->property_active(),
        Glib::Binding::Flags::SYNC_CREATE | Glib::Binding::Flags::BIDIRECTIONAL);
}

void CReaderMpKeysDialog::on_bind_key(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::EditableLabel*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property_value(
        col->m_property_key.get_proxy(), label->property_text(), Glib::Binding::Flags::SYNC_CREATE,
        sigc::mem_fun(*this, &CReaderMpKeysDialog::key_transform_to),
        sigc::mem_fun(*this, &CReaderMpKeysDialog::key_transform_from));
}

bool CReaderMpKeysDialog::key_transform_to(const GValue* a, GValue* b) {
    auto pSrc = (const my_key*)a->data->v_pointer;
    if (b->g_type != G_TYPE_STRING)
        return false;
    if (pSrc->m_fValid)
        g_value_set_string(b, KeyToString(pSrc->m_key).c_str());
    else
        g_value_set_string(b, "");
    return true;
}

bool CReaderMpKeysDialog::key_transform_from(const GValue* a, GValue* b) {
    if (a->g_type != G_TYPE_STRING)
        return false;
    auto pDest = (my_key*)b->data->v_pointer;
    auto pValue = g_value_get_string(a);
    if ('\0' == *pValue) {
        pDest->m_fValid = false;
        return true;
    }
    else if (TryParseKey(pValue, pDest->m_key)) {
        pDest->m_fValid = true;
        return true;
    }
    return false;
}

void CReaderMpKeysDialog::on_key_label_editing_change(Gtk::ListItem* list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::EditableLabel*>(list_item->get_child());
    if (!label)
        return;
    if (!label->get_editing()) {
        auto fOk = false;
        my_key key;
        auto sText = label->get_text();
        if (sText.empty()) {
            key.m_fValid = false;
            fOk = true;
        }
        else if (TryParseKey(sText.c_str(), key.m_key)) {
            fOk = true;
            key.m_fValid = true;
        }
        else {
            key = col->m_property_key.get_value();
            if (key.m_fValid)
                label->set_text(KeyToString(key.m_key));
            else
                label->set_text("");
        }
        if (fOk) {
            col->m_property_key.set_value(key);
            m_fModifed = true;

            auto nKeyTypeIdx = m_Notebook.get_current_page();
            auto fNewValid = key.m_fValid;
            auto fOldValid = GET_BIT(m_refSettings->m_aMpValidRdKeys[nKeyTypeIdx], col->m_nIdx);
            auto fChanged =
                (fOldValid != fNewValid) ||
                (fNewValid &&
                 (key.m_key != m_refSettings->m_aMpRdKeys[nKeyTypeIdx][col->m_nIdx].m_Key));

            const char* kChangeClassName = "changed";
            if (label->has_css_class(kChangeClassName) != fChanged) {
                if (fChanged)
                    label->add_css_class(kChangeClassName);
                else
                    label->remove_css_class(kChangeClassName);
            }
        }
    }
}

void CReaderMpKeysDialog::on_bind_comment(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::EditableLabel*>(list_item->get_child());
    if (!label)
        return;
    Glib::Binding::bind_property(col->m_property_comment.get_proxy(), label->property_text(),
                                 Glib::Binding::Flags::SYNC_CREATE);
}

void CReaderMpKeysDialog::on_comment_label_editing_change(Gtk::ListItem* list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::EditableLabel*>(list_item->get_child());
    if (!label)
        return;
    if (!label->get_editing()) {
        auto text = label->get_text();
        if (col->m_property_comment.get_value() != text) {
            col->m_property_comment.set_value(text);
            m_fModifed = true;
        }
    }
}

void CReaderMpKeysDialog::on_button_writeall() {
    SaveViewData();
    DoWriteKeys(true);
}

void CReaderMpKeysDialog::on_button_cancel() {
    set_visible(false);
}

void CReaderMpKeysDialog::on_button_ok() {
    SaveViewData();
    if ((m_nChangedKeys != 0) && !DoWriteKeys())
        return;
    set_visible(false);
}

void CReaderMpKeysDialog::on_dialog_response(int) {
    m_refDialog = nullptr;
}

void CReaderMpKeysDialog::UpdateView(bool fKeyB) {
    int nTypeKeyIdx = fKeyB ? 1 : 0;
    auto& oListStore = m_aListStore[nTypeKeyIdx];
    oListStore->remove_all();
    if (m_refSettings) {
        for (size_t i = 0; i < std::size(m_refSettings->m_aMpRdKeys[nTypeKeyIdx]); i++) {
            auto& rInfo = m_refSettings->m_aMpRdKeys[nTypeKeyIdx][i];
            auto fValid = GET_BIT(m_refSettings->m_aMpValidRdKeys[nTypeKeyIdx], i);
            auto fCheck = GET_BIT(m_refSettings->m_aMpCheckRdKeys[nTypeKeyIdx], i);
            oListStore->append(
                ModelColumns::create(fCheck, i, my_key(fValid, rInfo.m_Key), rInfo.m_sComment));
        }
    }
}

void CReaderMpKeysDialog::SaveViewData() {
    uint nChangeKeyBit = 0;
    for (size_t i = 0; i < std::size(m_aListStore); i++) {
        auto& oListStore = m_aListStore[i];
        auto nChecks = m_refSettings->m_aMpCheckRdKeys[i];
        auto nValids = m_refSettings->m_aMpValidRdKeys[i];
        auto nCount = oListStore->get_n_items();
        for (size_t j = 0; j < nCount; j++) {
            auto item = oListStore->get_item(j);
            SET_BIT(nChecks, j, item->m_property_check.get_value());
            auto key = item->m_property_key.get_value();
            SET_BIT(nValids, j, key.m_fValid);
            if (key.m_fValid) {
                SET_BIT(m_nChangedKeys, nChangeKeyBit, true);
                m_refSettings->SetMpRdKey(i, j, key.m_key);
            }
            m_refSettings->SetMpRdKeyComment(i, j, item->m_property_comment.get_value().c_str());
            ++nChangeKeyBit;
        }
        m_refSettings->SetMpCheckRdKeys(i, nChecks);
        m_refSettings->SetMpValidRdKeys(i, nValids);
    }
}

bool CReaderMpKeysDialog::DoWriteKeys(bool fForce) {
    try {
        uint nChangeKeyBit = 0;
        for (size_t i = 0; i < std::size(m_refSettings->m_aMpRdKeys); i++) {
            for (size_t j = 0; j < std::size(m_refSettings->m_aMpRdKeys[i]); j++) {
                if (fForce || GET_BIT(m_nChangedKeys, nChangeKeyBit)) {
                    if (GET_BIT(m_refSettings->m_aMpValidRdKeys[i], j))
                        m_oReader.WriteMfPKey(j, 1 == i, &m_refSettings->m_aMpRdKeys[i][j].m_Key,
                                              1);
                    SET_BIT(m_nChangedKeys, nChangeKeyBit, false);
                }
                ++nChangeKeyBit;
            }
        }
    }
    catch (const std::exception& e) {
        // std::cerr << e.what() << '\n';
        ShowMessage(e.what(), Gtk::MessageType::ERROR);
        return false;
    }
    return true;
}

void CReaderMpKeysDialog::ShowMessage(const std::string& sMessage, Gtk::MessageType nType) {
    if (nullptr == m_refDialog)
        m_refDialog.reset(new Gtk::MessageDialog("Демо", false, nType));
    m_refDialog->set_transient_for(*this);
    m_refDialog->set_message(sMessage);
    m_refDialog->show();
    m_refDialog->signal_response().connect(
        sigc::bind(sigc::mem_fun(*this, &CReaderMpKeysDialog::on_dialog_response)));
}

std::string CReaderMpKeysDialog::KeyToString(const ilr_mf_plus_key& key) const {
    char szBuf[48];
    auto c = snprintf(szBuf, std::size(szBuf), "%.12llx %.12llx", key.ll.hi, key.ll.lo);
    if (c <= 0)
        return std::string();
    return std::string(szBuf, c);
}

bool CReaderMpKeysDialog::TryParseKey(const char* pStr, ilr_mf_plus_key& key) const {
    char* p = nullptr;
    errno = 0;
    auto n = strtoull(pStr, &p, 16);
    if ((errno != 0) || (p == pStr))
        return false;
    key.ll.hi = n;
    if (' ' == *p)
        ++p;
    pStr = p;
    n = strtoull(pStr, &p, 16);
    if ((errno != 0) || (p == pStr))
        return false;
    key.ll.lo = n;
    return true;
}
