#pragma once
#include <gtkmm.h>

#include <filesystem>

#include "CMfClassicKeysSettings.h"
#include "CMfPlusKeysSettings.h"
#include "CMfSecurityLevelDialog.h"
#include "CMfUltralightDialog.h"
#include "CMifareClassicDialog.h"
#include "CMifarePlusDialog.h"
#include "CMifareReaderSettings.h"
#include "CReaderMcKeysDialog.h"
#include "CReaderMpKeysDialog.h"
#include "CTemicDialog.h"
#include "CTemicPasswordsDialog.h"
#include "CTemicPasswordsSettings.h"
#include "CTemicReaderSettings.h"
#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"

class CReaderDialog : public Gtk::Window {
public:
    CReaderDialog();
    ~CReaderDialog() override;

    void Init(ilr::CReader& oReader);

protected:
    void on_button_connect();
    void on_button_disconnect();
    void on_button_card_refresh();
    void on_button_open();
    void on_button_sl();
    void on_mfsl_dialog_hide();
    void on_ts_editing_done();
    void on_ts_selected();
    void on_button_toggle_password();
    void on_button_edit_passwords();
    void on_temic_passwords_dialog_hide();
    void on_password_selected_changed();
    void on_button_scan_temic();
    void on_button_init_temic();
    void on_confirm_init_temic_dialog_response(int response_id);
    void on_button_toggle_scan_temic();
    void on_button_mckeys();
    void on_mckeys_dialog_hide();
    void on_button_mpkeys();
    void on_mpkeys_dialog_hide();
    void on_mfultralight_dialog_hide();
    void on_mfclassic_dialog_hide();
    void on_mfplus_dialog_hide();
    void on_temic_dialog_hide();
    void on_dialog_response(int);
    void on_hide();
    static void ILR_CALL on_ilr_message(ilr_reader_msg nMsg, const void* pMsgData, void* pUserData);
    void on_ilr();

    void ShowMfUltralightDialog();
    void ShowMfClassicDialog();
    void ShowMfPlusDialog();
    void ShowTemicDialog();
    void MessageDialog(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO,
                       Gtk::ButtonsType nButtons = Gtk::ButtonsType::OK,
                       Gio::ActionMap::ActivateWithIntParameterSlot&& slot =
                           Gio::ActionMap::ActivateWithIntParameterSlot());
    void UpdateConnectionStatus();
    void UpdateReaderInfo();
    void UpdateCurrentCard();
    void UpdateTemicPasswordDropDown();
    bool TryParseTemicScanParam(const char* pStr, int& nScanParam);
    std::string TemicScanParamToString(int nScanParam);
    void SaveSettings();
    std::filesystem::path GetSettingFilePath() const;

protected:
    ilr::CReader m_oReader;  // Считыватель
    ilr_reader_model m_nModel;
    int m_nReaderSn;  // Серийный номер считывателя
    bool m_fCanRwMfClassic;
    bool m_fCanRwMfPlus;
    bool m_fCanRwMfUltralight;
    bool m_fCanRwTemic;
    bool m_fLockUpdate;  // True, заблокировать обработку событий
    ilr_card_info m_rCardInfo;
    Glib::RefPtr<CMifareReaderSettings> m_refMfSet;  // Настройки считывателя Mifare
    Glib::RefPtr<CMfClassicKeysSettings> m_refMcKeys;  // Список ключей Mifare Classic
    Glib::RefPtr<CMfPlusKeysSettings> m_refMpKeys;     // Список ключей Mifare Plus
    Glib::RefPtr<CTemicReaderSettings> m_refTmcSet;  // Настройки считывателя Temic
    Glib::RefPtr<CTemicPasswordsSettings> m_refTmcPasswords;  // Список паролей Temic

    Gtk::Box m_VBox;           // Основная панель
    Gtk::Frame m_StatusFrame;  // Группа "Состояние подключения"
    Gtk::Box m_StatusBox;  // Панель внутри группы "Состояние подключения"
    Gtk::Label m_StatusLabel;  // Текстовая метка в группе "Состояние подключения"
    Gtk::Button m_ConnectButton;     // Кнопка "Подключиться"
    Gtk::Button m_DisconnectButton;  // Кнопка "Отключиться"
    Gtk::Frame m_CardFrame;          // Группа "Текущая карта"
    Gtk::Grid m_CardGrid;  // Панель внутри группы "Текущая карта"
    Gtk::Label m_CardLabel;
    Gtk::Button m_CardRefreshButton;  // Кнопка "Обновить"
    Gtk::Button m_OpenButton;         // Кнопка "Открыть..."
    Gtk::Button m_SlButton;  // Кнопка "Изменить уровень безопасности..."
    Gtk::Frame m_TemicFrame;  // Группа "Параметры поиска карт Temic"
    Gtk::Grid m_TemicGrid;
    Gtk::Frame m_TsFrame;  // Группа "Тип и скорость"
    Gtk::ComboBoxText m_TsComboBox;
    Gtk::Frame m_PasswordFrame;  // Группа "Пароль"
    Gtk::Box m_PasswordBox;
    Gtk::CheckButton m_PasswordCheckButton;  // Флажок "Пароль"
    Gtk::DropDown m_PasswordDropDown;
    Glib::RefPtr<Gtk::StringList> m_refPasswordStringList;
    Gtk::Button m_PasswEditButton;  // Кнопка "..." для изменения списка паролей Temic
    Gtk::Box m_TemicButtonsBox;
    Gtk::Button m_TemicScanButton;  // Кнопка "Сканировать"
    Gtk::Button m_TemicInitButton;  // Кнопка "Инициализировать Temic"
    Gtk::CheckButton m_ScanTemicCheckButton;  // Флажок "Автоматически сканировать карты Temic"
    Gtk::Box m_BottomBox;
    Gtk::Button m_McKeysButton;                           // Кнопка "Ключи Classic..."
    Gtk::Button m_MpKeysButton;                           // Кнопка "Ключи Plus..."
    Glib::RefPtr<CReaderMcKeysDialog> m_refMcKeysDialog;  // Окно "Ключи Mifare Classic считывателя"
    Glib::RefPtr<CReaderMpKeysDialog> m_refMpKeysDialog;  // Окно "Ключи Mifare Plus считывателя"
    Glib::RefPtr<CMfSecurityLevelDialog>
        m_refMfSlDialog;  // Окно "Уровень безопасности карты Mifare Plus"
    Glib::RefPtr<CTemicPasswordsDialog> m_refTemicPasswordsDialog;  // Окно "Пароли Temic"
    Glib::RefPtr<CMfUltralightDialog> m_refMfUltralightDialog;      // Окно  "Mifare Ultralight"
    Glib::RefPtr<CMifareClassicDialog> m_refMfClassicDialog;        // Окно  "Mifare Classic"
    Glib::RefPtr<CMifarePlusDialog> m_refMfPlusDialog;              // Окно  "Mifare Plus"
    Glib::RefPtr<CTemicDialog> m_refTemicDialog;                    // Окно  "Temic"
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;

    Glib::Dispatcher m_oDisp;  // Для синхронизации Callback-функций SDK Readers
};
