#pragma once
#include <gtkmm.h>

#include <vector>

#include "CCardDataGrid.h"
#include "CErrorsDialog.h"
#include "CMfClassicKeysDialog.h"
#include "CMfClassicKeysSettings.h"
#include "CReaderMcKeysDialog.h"
#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"

class CMifareClassicDialog : public Gtk::Window {
public:
    CMifareClassicDialog();
    ~CMifareClassicDialog() override;

    void Init(const ilr::CReader& oReader, Glib::RefPtr<CMifareReaderSettings> refSets,
              Glib::RefPtr<CMfClassicKeysSettings> refKeys);

protected:
    void on_explicit_key_button_clicked();
    void on_keys_dialog_hide();
    void on_reader_keys_button_clicked();
    void on_rdkeys_dialog_hide();
    void on_group_selected_row_changed();
    void on_explicit_key_toggled();
    void on_reader_keys_toggled();
    uint on_data_get_byte_access(uint nAddress);
    void on_data_grid_select_cell();
    void on_data_grid_rclick(int n_press, double x, double y);
    void on_menu_read_sector();
    void on_menu_read_group();
    void on_menu_read_all();
    void on_menu_write_sector();
    void on_menu_write_group();
    void on_menu_write_all();
    void on_menu_format(int parameter);
    void on_serial_color_set();
    void on_user_data_color_set();
    void on_user_data_ro_color_set();
    void on_value_color_set();
    void on_value_dtr_color_set();
    void on_nrw_data_color_set();
    void on_access_bits_color_set();
    void on_access_bits_ro_color_set();
    void on_key_color_set();
    void on_nrw_key_color_set();
    void on_hex_toggled();
    void on_dec_toggled();
    void on_oct_toggled();
    void on_bin_toggled();
    void on_value_block_value_changed();
    void on_value_block_increment();
    void on_value_block_decrement();
    void on_value_block_transfer();
    void on_value_block_restore();
    void on_value_block_address_changed();
    void on_button_sector_key_a();
    void on_sector_key_a_keys_dialog_hide();
    void on_button_sector_key_b();
    void on_sector_key_b_keys_dialog_hide();
    void on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_trailer_bind_bits(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool area_bits_transform_to(const GValue* a, GValue* b);
    void on_trailer_bind_read_a(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_trailer_bind_write_a(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool trailer_write_a_transform_to(const GValue* a, GValue* b);
    void on_trailer_bind_read_access(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool trailer_read_access_transform_to(const GValue* a, GValue* b);
    void on_trailer_bind_write_access(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool trailer_write_access_transform_to(const GValue* a, GValue* b);
    void on_trailer_bind_read_b(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool trailer_read_b_transform_to(const GValue* a, GValue* b);
    void on_trailer_bind_write_b(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool trailer_write_b_transform_to(const GValue* a, GValue* b);
    void on_trailer_bind_remark(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool trailer_remark_transform_to(const GValue* a, GValue* b);
    void on_trailer_column_view_activate(guint pos);
    void on_popover_trailer_column_view_activate(guint pos);
    void on_user_data_bind_area(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool area_transform_to(const GValue* a, GValue* b);
    void on_user_data_bind_bits(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_user_data_bind_read(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool user_data_read_transform_to(const GValue* a, GValue* b);
    void on_user_data_bind_write(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool user_data_write_transform_to(const GValue* a, GValue* b);
    void on_user_data_bind_increment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool user_data_increment_transform_to(const GValue* a, GValue* b);
    void on_user_data_bind_dtr(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool user_data_dtr_transform_to(const GValue* a, GValue* b);
    void on_user_data_bind_remark(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool user_data_remark_transform_to(const GValue* a, GValue* b);
    void on_user_data_column_view_activate(guint pos);
    void on_popover_user_data_column_view_activate(guint pos);
    void on_button_read();
    void on_button_write();
    void on_button_errors();
    void on_dialog_response(int);
    void on_error_dialog_hide();
    void on_hide();

protected:
    // Информация о секторе Mifare Classic
    class CMfSectorInfo {
    public:
        bool m_fAuthOk;  // True, авторизации прошла успешно
        // Параметры авторизации
        bool m_fKeyB;  // True, авторизован по ключу B, иначе - по ключу A
        int m_nRdKeyIdx;  // Номер ключа аутентификации в памяти считывателя
        ilr::CMifareClassicKey m_AuthKey;  // Явный ключ аутентификации
        // Данные сектора
        bool m_fReadDataOk;  // True, чтение сектора выполнено (возможно с ошибками)
        uint m_nInitBlocks;  // Биты успешно прочитанных блоков сектора
        bool m_aKeyInit[2];  // [KeyB] = True ключ известный
    };

    // Строка списка групп секторов для ListBox
    class CGroupListRow : public Gtk::ListBoxRow {
    public:
        CGroupListRow() {
            set_child(m_Label);
            set_halign(Gtk::Align::START);
        }

        void set_text(const std::string& text) {
            m_Label.set_label(text);
        }

    protected:
        Gtk::Label m_Label;
    };

    // A Gio::ListStore item.
    class CTrailerModelColumns : public Glib::Object {
    public:
        Glib::Property<uint> m_property_bits;  // Биты доступа

        static Glib::RefPtr<CTrailerModelColumns> create(uint nBits) {
            return Glib::make_refptr_for_instance<CTrailerModelColumns>(
                new CTrailerModelColumns(nBits));
        }

    protected:
        CTrailerModelColumns(uint nBits) :
            Glib::ObjectBase(typeid(CTrailerModelColumns)),
            m_property_bits(*this, "bits", nBits) {
        }
    };  // CTrailerModelColumns

    class CUserDataModelColumns : public Glib::Object {
    public:
        Glib::Property<uint> m_property_area;  // Область
        Glib::Property<uint> m_property_bits;  // Биты доступа

        static Glib::RefPtr<CUserDataModelColumns> create(uint nBits, uint nAreaIdx) {
            return Glib::make_refptr_for_instance<CUserDataModelColumns>(
                new CUserDataModelColumns(nBits, nAreaIdx));
        }

    protected:
        CUserDataModelColumns(uint nBits, uint nAreaIdx) :
            Glib::ObjectBase(typeid(CUserDataModelColumns)),
            m_property_area(*this, "area", nAreaIdx),
            m_property_bits(*this, "bits", nBits) {
        }
    };  // CUserDataModelColumns

protected:
    // Читает данные из карты
    void ReadCardData();
    void ReadCardData(uint nSectorIdx, uint nSectorCount);
    // Перечитывает текущий сектор
    void ReadCurrentSector();
    // Перечитывает текущую группу
    void ReadCurrentGroup();
    // Записывает данные на карту
    void WriteCardData();
    void WriteCardData(uint nSectorIdx, uint nSectorCount);
    // Записывает изменённые блоки текущего сектора
    void WriteSector();
    // Записывает изменённые блоки текущей группы секторов
    void WriteGroup();
    // Устанавливает видимый диапазон блоков
    void SetViewDataRange(uint nFirstBlockIdx, uint nBlockCount);
    // Устанавливает биты доступа области (C1 C2 C3)
    void SetSectorAreaAccess(uint nSectorIdx, uint nAreaIdx, uint nAreaAccess);
    // Устанавливает значение для блока-значения
    void SetValueBlockValue(size_t nBlockIdx, int nValue);
    // Устанавливает адрес для блока-значения
    void SetValueBlockAddress(size_t nBlockIdx, uint nAddress);

    void AddErrorMessage(const Glib::ustring& sMessage, bool fShowDialog = true);
    void ShowErrorsDialog();
    void UpdateDataGridColors();
    void UpdateGroupListBox();
    void UpdateValueBlockGroup();
    void UpdateSectorConfigGroup();
    void UpdateAuthGroupData(bool fSave);
    void UpdateAuthRdKeysCtrlData(bool fSave);
    void SelectFormat(byte_format nFormat);
    void SelectAreaAccess(size_t nAreaIdx, uint32_t nAreaAccess);
    void configure_trailer_column_view(
        Gtk::ColumnView& ColumnView,
        Glib::RefPtr<Gio::ListStore<CTrailerModelColumns>>& refListStore, bool fPopup);
    guint FindPTrailerBits(uint nBits) const;
    void configure_userdata_column_view(
        Gtk::ColumnView& ColumnView,
        Glib::RefPtr<Gio::ListStore<CUserDataModelColumns>>& refListStore, bool fPopup);
    guint FindPUserDataBits(uint nBits) const;
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);

protected:
    ilr::CReader m_oReader;                          // Считыватель
    ilr::CCardUID m_CardUid;                         // Id карты
    Glib::RefPtr<CMifareReaderSettings> m_refSets;   // Настройки считывателя
    Glib::RefPtr<CMfClassicKeysSettings> m_refKeys;  // Список ключей Mifare Classic
    std::vector<ilr_mf_block_data> m_oOldBlocks;     // Оригинальные данные
    std::vector<ilr_mf_block_data> m_oNewBlocks;     // Изменённые данные
    std::vector<CMfSectorInfo> m_oSectors;  // Список секторов (информация)
    int m_nSectorIdx;  // Номер текущего сектора для панели "Конфигурация сектора"
    // Параметры авторизации
    bool m_fAuthKeyB;  // True, авторизация по ключу Б, иначе - по ключу А
    bool m_fAuthByRdKeys;  // True, авторизация по ключу из памяти считывателя, иначе - по явному
                           // ключу
    ilr::CMifareClassicKey m_AuthKey;  // Ключ аутентификации
    bool m_fLockUpdate;  // True, заблокировать обработку событий

    Gtk::Box m_VBox;
    Gtk::Frame m_AuthFrame;  // Группа "Авторизация"
    Gtk::Box m_AuthBox;
    Gtk::Frame m_AuthKeyFrame;  // Группа "Ключ"
    Gtk::Box m_AuthKeyBox;
    Gtk::CheckButton m_ExplicitKeyCheckButton;  // Переключатель "Явный ключ"
    Gtk::CheckButton m_ReaderKeysCheckButton;  // Переключатель "Ключи считывателя"
    Gtk::Frame m_AuthKeyTypeFrame;  // Группа "Тип ключа"
    Gtk::Box m_AuthKeyTypeBox;
    Gtk::CheckButton m_KeyACheckButton;  // Переключатель "Ключ А"
    Gtk::CheckButton m_KeyBCheckButton;  // Переключатель "Ключ Б"
    Gtk::Notebook m_AuthKeysNotebook;
    Gtk::Box m_ExplicitKeyBox;
    Gtk::Entry m_ExplicitKeyEntry;
    Gtk::Button m_ExplicitKeyButton;  // Кнопка "..." показывает окно "Ключи Mifare Classic"
    Gtk::Grid m_ReaderKeysGrid;
    Gtk::CheckButton m_aReaderKeyCheckButtons[16];  // Флажки ключей считывателя
    Gtk::Button m_ReaderKeysButton;  // Кнопка "..." показывает окно "Ключи считывателя"
    Gtk::Box m_MiddleBox;
    Gtk::ScrolledWindow m_GroupScrolledWindow;
    Gtk::ListBox m_GroupListBox;
    std::vector<CGroupListRow> m_GroupListRows;
    Gtk::Box m_DataVBox;
    Gtk::Box m_DataHBox;
    Gtk::ScrolledWindow m_DataRightScrolledWindow;
    Gtk::Box m_DataRightBox;
    Gtk::ScrolledWindow m_DataScrolledWindow;
    CCardDataGrid m_CardDataGrid;
    Glib::RefPtr<Gtk::GestureClick> m_refRClick;
    Gtk::PopoverMenu m_MenuPopup;
    Glib::RefPtr<Gio::SimpleAction> m_refFormatAction;
    Glib::RefPtr<Gtk::Builder> m_refBuilder;
    Gtk::Frame m_DataLegendFrame;  // Группа "Легенда для данных"
    Gtk::Grid m_DataLegendGrid;
    Gtk::ColorButton m_SerialButton;      // Кнопка "Серийный номер"
    Gtk::Label m_SerialLabel;             // Метка "Серийный номер"
    Gtk::ColorButton m_UserDataButton;    // Кнопка "Данные пользователя"
    Gtk::Label m_UserDataLabel;           // Метка "Данные пользователя"
    Gtk::ColorButton m_UserDataRoButton;  // Кнопка "Данные (только чтение)"
    Gtk::Label m_UserDataRoLabel;         // Метка "Данные (только чтение)"
    Gtk::ColorButton m_ValueButton;       // Кнопка "Блок-значение"
    Gtk::Label m_ValueLabel;              // Метка "Блок-значение"
    Gtk::ColorButton m_ValueDtrButton;  // Кнопка "Блок-значение (только Д/П/В)"
    Gtk::Label m_ValueDtrLabel;  // Метка "Блок-значение (только Д/П/В)"
    Gtk::ColorButton m_NrwDataButton;  // Кнопка "Данные (нельзя читать/писать)"
    Gtk::Label m_NrwDataLabel;  // Метка "Данные (нельзя читать/писать)"
    Gtk::Frame m_TrailerLegendFrame;  // Группа "Легенда для прицепа"
    Gtk::Grid m_TrailerLegendGrid;
    Gtk::ColorButton m_AccessBitsButton;  // Кнопка "Биты доступа"
    Gtk::Label m_AccessBitsLabel;         // Метка "Биты доступа"
    Gtk::ColorButton m_AccessBitsRoButton;  // Кнопка "Биты доступа (только чтение)"
    Gtk::Label m_AccessBitsRoLabel;  // Метка "Биты доступа (только чтение)"
    Gtk::ColorButton m_KeyButton;  // Кнопка "Ключ"
    Gtk::Label m_KeyLabel;         // Метка "Ключ"
    Gtk::ColorButton m_NrwKeyButton;  // Кнопка "Ключ (нельзя читать/писать)"
    Gtk::Label m_NrwKeyLabel;  // Метка "Ключ (нельзя читать/писать)"
    Gtk::Frame m_FormatFrame;  // Группа "Формат данных"
    Gtk::Box m_FormatBox;
    Gtk::CheckButton m_HexCheckButton;  // Переключатель "Шестнадцатеричный"
    Gtk::CheckButton m_DecCheckButton;  // Переключатель "Десятичный"
    Gtk::CheckButton m_OctCheckButton;  // Переключатель "Восьмеричный"
    Gtk::CheckButton m_BinCheckButton;  // Переключатель "Двоичный"
    Gtk::Frame m_SectorFrame;           // Группа "Конфигурация сектора"
    Gtk::Box m_SectorBox;
    Gtk::Frame m_ValueBlockFrame;  // Группа "Блок-значение"
    Gtk::Grid m_ValueGrid;
    Gtk::Label m_Value2Label;  // Метка "Значение:"
    Glib::RefPtr<Gtk::Adjustment> m_refValueAdjustment;
    Gtk::SpinButton m_ValueSpinButton;
    Gtk::Label m_AddressLabel;  // Метка "Адрес:"
    Glib::RefPtr<Gtk::Adjustment> m_refAddressAdjustment;
    Gtk::SpinButton m_AddressSpinButton;
    Gtk::Label m_ValueDeltaLabel;  // Метка: "Изменить на:"
    Glib::RefPtr<Gtk::Adjustment> m_refValueDeltaAdjustment;
    Gtk::SpinButton m_ValueDeltaSpinButton;
    Gtk::Button m_IncrementButton;  // Кнопка "Увеличить"
    Gtk::Button m_DecrementButton;  // Кнопка "Уменьшить"
    Gtk::Button m_TransferButton;   // Кнопка "Передать"
    Gtk::Button m_RestoreButton;    // Кнопка "Восстановить"
    Gtk::Frame m_SectorKeysFrame;   // Группа "Ключи авторизации"
    Gtk::Box m_SectorKeysBox;
    Gtk::Label m_SectorKeyALabel;    // Метка "Ключ А"
    Gtk::Entry m_SectorKeyAEntry;    // Поле ввода "Ключ А"
    Gtk::Button m_SectorKeyAButton;  // Кнопка "Ключи.." для поля "Ключ А"
    Gtk::Label m_SectorKeyBLabel;    // Метка "Ключ Б"
    Gtk::Entry m_SectorKeyBEntry;
    Gtk::Button m_SectorKeyBButton;  // Кнопка "Ключи.." для поля "Ключ Б"
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;
    Gtk::Frame m_SectorTrailerFrame;  // Группа "Доступ прицепа"
    Gtk::ColumnView m_TrailerColumnView;
    Glib::RefPtr<Gio::ListStore<CTrailerModelColumns>> m_TrailerListStore;
    Gtk::Popover m_TrailerPopover;
    Gtk::ColumnView m_PTrailerColumnView;
    Glib::RefPtr<Gio::ListStore<CTrailerModelColumns>> m_PTrailerListStore;
    Gtk::Frame m_SectorUserDataFrame;  // Группа "Доступ к данным пользователя"
    Glib::RefPtr<Gio::ListStore<CUserDataModelColumns>> m_UserDataListStore;
    Gtk::ColumnView m_UserDataColumnView;
    Gtk::Popover m_UserDataPopover;
    Gtk::ColumnView m_PUserDataColumnView;
    Glib::RefPtr<Gio::ListStore<CUserDataModelColumns>> m_PUserDataListStore;

    Gtk::Box m_BottomBox;        // Нижняя панель с кнопками
    Gtk::Button m_ReadButton;    // Кнопка "Читать"
    Gtk::Button m_WriteButton;   // Кнопка "Записать"
    Gtk::Button m_ErrorsButton;  // Кнопка "Сообщения об ошибках..."
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Glib::RefPtr<CMcKeysDialog> m_refKeysDialog;  // Окно "Ключи Mifare Classic"
    Glib::RefPtr<CReaderMcKeysDialog> m_refRdKeysDialog;  // Окно "Ключи Mifare Classic считывателя"
    Glib::RefPtr<CErrorsDialog> m_refErrorDialog;  // Окно "Ошибки"
};
