#include "CMfClassicKeysSettings.h"

#include <fstream>

CMfClassicKeysSettings::CMfClassicKeysSettings() :
    m_fModified(false) {
}

void CMfClassicKeysSettings::Load(const std::filesystem::path& path) {
    m_fModified = false;
    m_oKeys.clear();
    if (std::filesystem::exists(path)) {
        std::ifstream inFile;
        inFile.open(path);
        inFile >> std::hex;
        CMcKeyInfo r;
        while (true) {
            inFile >> r.m_Key.m_nKey >> std::quoted(r.m_sComment);
            if (!inFile.good())
                break;
            m_oKeys.emplace_back(std::move(r));
        }
    }
}

void CMfClassicKeysSettings::Save(const std::filesystem::path& path) {
    std::ofstream outFile;
    outFile.open(path);
    outFile.imbue(std::locale("C"));
    outFile << std::hex;
    for (auto& r : m_oKeys) {
        outFile << r.m_Key.m_nKey << '\t' << std::quoted(r.m_sComment) << std::endl;
    }
    m_fModified = false;
}
