#include "CAppSettings.h"

#include <limits.h>
#include <unistd.h>

#include <fstream>

CAppSetings g_AppSet;

CAppSetings::CAppSetings() :
    m_fModified(false),
    m_fDebugLog(false),
    m_fClearLogAtStartup(true),
    m_nLogLevel(ILR_LOG_LEVEL_DEBUG),
    m_nReaderTypes(ILR_READER_ILUSB | ILR_READER_SERVER | ILR_READER_CLIENT),
    m_nDataFormat(byte_format::BYTE_FORMAT_HEX),
    m_fShowUnidentified(true),
    m_MfUlSerialColor(0.65, 0.79, 0.94),
    m_MfUlLockColor(1.0, 1.0, 0.6),
    m_MfUlLockRoColor(0.87, 0.87, 0.74),
    m_MfUlUserDataColor(0.66, 0.94, 0.66),
    m_MfUlUserDataRoColor(0.74, 0.86, 0.74),
    m_TmcSerialColor(0.65, 0.79, 0.94),
    m_TmcPasswordColor(1.0, 0.75, 0.44),
    m_TmcUserDataColor(0.66, 0.94, 0.66),
    m_TmcConfigColor(1.0, 1.0, 0.6),
    m_nTmcNewCardType(ILR_CARD_EM_MARINE),
    m_McSerialColor(Gdk::RGBA(0.65, 0.79, 0.94)),
    m_McUserDataColor(Gdk::RGBA(0.66, 0.94, 0.66)),
    m_McUserDataRoColor(Gdk::RGBA(0.74, 0.86, 0.74)),
    m_McValueColor(Gdk::RGBA(0.61, 1.0, 1.0)),
    m_McValueDtrColor(Gdk::RGBA(0.73, 0.86, 0.86)),
    m_McNrwDataColor(Gdk::RGBA(0.75, 0.75, 0.75)),
    m_McAccessBitsColor(Gdk::RGBA(1.0, 1.0, 0.60)),
    m_McAccessBitsRoColor(Gdk::RGBA(0.87, 0.87, 0.74)),
    m_McKeyColor(Gdk::RGBA(0.84, 0.60, 1.0)),
    m_McNrwKeyColor(Gdk::RGBA(0.75, 0.75, 0.75)),
    m_fMfAuthRdKeys(false),
    m_fMfAuthKeyB(false),
    m_fMfOpenText(true),
    m_MpEnColor(Gdk::RGBA(0.84, 0.60, 1.0)) {
}

CAppSetings::~CAppSetings() {
}

std::filesystem::path CAppSetings::GetFilePath() const {
    char szCfgPath[PATH_MAX];
    auto count = readlink("/proc/self/exe", szCfgPath, std::size(szCfgPath) - 1);
    szCfgPath[count] = '\0';
    std::stringstream ss;
    ss << szCfgPath << ".settings.txt";
    return ss.str();
}

void CAppSetings::Load() {
    auto sPath(GetFilePath());
    if (std::filesystem::exists(sPath)) {
        std::ifstream inFile;
        inFile.open(sPath);

        uint n = (uint)m_nLogLevel;
        inFile >> std::dec >> n;
        if (n < ILR_LOG_LEVEL_SIZE)
            m_nLogLevel = (ilr_log_level)n;
        inFile >> std::boolalpha >> m_fDebugLog >> m_fClearLogAtStartup >> std::hex >>
            m_nReaderTypes >> m_fShowUnidentified;
        n = (uint)m_nDataFormat;
        inFile >> std::dec >> n;
        if ((n > byte_format::BYTE_FORMAT_UNDEF) && (n < byte_format::BYTE_FORMAT_SIZE))
            m_nDataFormat = (byte_format)n;
        uint n2, n3;
        n = m_MfUlSerialColor.get_red_u();
        n2 = m_MfUlSerialColor.get_green_u();
        n3 = m_MfUlSerialColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_MfUlSerialColor.set_rgba_u(n, n2, n3);

        n = m_MfUlLockColor.get_red_u();
        n2 = m_MfUlLockColor.get_green_u();
        n3 = m_MfUlLockColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_MfUlLockColor.set_rgba_u(n, n2, n3);

        n = m_MfUlLockRoColor.get_red_u();
        n2 = m_MfUlLockRoColor.get_green_u();
        n3 = m_MfUlLockRoColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_MfUlLockRoColor.set_rgba_u(n, n2, n3);

        n = m_MfUlUserDataColor.get_red_u();
        n2 = m_MfUlUserDataColor.get_green_u();
        n3 = m_MfUlUserDataColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_MfUlUserDataColor.set_rgba_u(n, n2, n3);

        n = m_MfUlUserDataRoColor.get_red_u();
        n2 = m_MfUlUserDataRoColor.get_green_u();
        n3 = m_MfUlUserDataRoColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_MfUlUserDataRoColor.set_rgba_u(n, n2, n3);

        n = m_TmcSerialColor.get_red_u();
        n2 = m_TmcSerialColor.get_green_u();
        n3 = m_TmcSerialColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_TmcSerialColor.set_rgba_u(n, n2, n3);

        n = m_TmcPasswordColor.get_red_u();
        n2 = m_TmcPasswordColor.get_green_u();
        n3 = m_TmcPasswordColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_TmcPasswordColor.set_rgba_u(n, n2, n3);

        n = m_TmcUserDataColor.get_red_u();
        n2 = m_TmcUserDataColor.get_green_u();
        n3 = m_TmcUserDataColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_TmcUserDataColor.set_rgba_u(n, n2, n3);

        n = m_TmcConfigColor.get_red_u();
        n2 = m_TmcConfigColor.get_green_u();
        n3 = m_TmcConfigColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_TmcConfigColor.set_rgba_u(n, n2, n3);

        n = (uint)m_nTmcNewCardType;
        inFile >> std::dec >> n;
        if (n < ILR_CARD_TYPE_SIZE)
            m_nTmcNewCardType = (ilr_card_type)n;

        std::string s;
        inFile >> s;
        m_rNewEmMarineUid.TryParse(s.c_str());

        s.clear();
        inFile >> s;
        m_rNewHidUid.TryParse(s.c_str());

        n = m_McSerialColor.get_red_u();
        n2 = m_McSerialColor.get_green_u();
        n3 = m_McSerialColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McSerialColor.set_rgba_u(n, n2, n3);

        n = m_McUserDataColor.get_red_u();
        n2 = m_McUserDataColor.get_green_u();
        n3 = m_McUserDataColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McUserDataColor.set_rgba_u(n, n2, n3);

        n = m_McUserDataRoColor.get_red_u();
        n2 = m_McUserDataRoColor.get_green_u();
        n3 = m_McUserDataRoColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McUserDataRoColor.set_rgba_u(n, n2, n3);

        n = m_McValueColor.get_red_u();
        n2 = m_McValueColor.get_green_u();
        n3 = m_McValueColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McValueColor.set_rgba_u(n, n2, n3);

        n = m_McValueDtrColor.get_red_u();
        n2 = m_McValueDtrColor.get_green_u();
        n3 = m_McValueDtrColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McValueDtrColor.set_rgba_u(n, n2, n3);

        n = m_McNrwDataColor.get_red_u();
        n2 = m_McNrwDataColor.get_green_u();
        n3 = m_McNrwDataColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McNrwDataColor.set_rgba_u(n, n2, n3);

        n = m_McAccessBitsColor.get_red_u();
        n2 = m_McAccessBitsColor.get_green_u();
        n3 = m_McAccessBitsColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McAccessBitsColor.set_rgba_u(n, n2, n3);

        n = m_McAccessBitsRoColor.get_red_u();
        n2 = m_McAccessBitsRoColor.get_green_u();
        n3 = m_McAccessBitsRoColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McAccessBitsRoColor.set_rgba_u(n, n2, n3);

        n = m_McKeyColor.get_red_u();
        n2 = m_McKeyColor.get_green_u();
        n3 = m_McKeyColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McKeyColor.set_rgba_u(n, n2, n3);

        n = m_McNrwKeyColor.get_red_u();
        n2 = m_McNrwKeyColor.get_green_u();
        n3 = m_McNrwKeyColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_McNrwKeyColor.set_rgba_u(n, n2, n3);

        inFile >> m_McAuthKey.m_nKey;
        inFile >> m_fMfAuthRdKeys >> m_fMfAuthKeyB;

        inFile >> m_MpAuthKey.ll.hi >> m_MpAuthKey.ll.lo;
        inFile >> m_fMfOpenText;

        n = m_MpEnColor.get_red_u();
        n2 = m_MpEnColor.get_green_u();
        n3 = m_MpEnColor.get_blue_u();
        inFile >> std::hex >> n >> n2 >> n3;
        m_MpEnColor.set_rgba_u(n, n2, n3);
    }
}

void CAppSetings::Save() {
    m_fModified = false;
    std::filesystem::path sPath(GetFilePath());
    std::ofstream outFile;
    outFile.open(sPath);
    outFile.imbue(std::locale("C"));
    outFile << std::showbase << std::dec << (uint)m_nLogLevel << '\t' << std::boolalpha
            << m_fDebugLog << '\t' << m_fClearLogAtStartup << std::endl
            << std::hex << m_nReaderTypes << '\t' << m_fShowUnidentified << std::endl
            << std::dec << (uint)m_nDataFormat << std::endl
            << std::hex << m_MfUlSerialColor.get_red_u() << '\t' << m_MfUlSerialColor.get_green_u()
            << '\t' << m_MfUlSerialColor.get_blue_u() << std::endl
            << m_MfUlLockColor.get_red_u() << '\t' << m_MfUlLockColor.get_green_u() << '\t'
            << m_MfUlLockColor.get_blue_u() << std::endl
            << m_MfUlLockRoColor.get_red_u() << '\t' << m_MfUlLockRoColor.get_green_u() << '\t'
            << m_MfUlLockRoColor.get_blue_u() << std::endl
            << m_MfUlUserDataColor.get_red_u() << '\t' << m_MfUlUserDataColor.get_green_u() << '\t'
            << m_MfUlUserDataColor.get_blue_u() << std::endl
            << m_MfUlUserDataRoColor.get_red_u() << '\t' << m_MfUlUserDataRoColor.get_green_u()
            << '\t' << m_MfUlUserDataRoColor.get_blue_u() << std::endl
            << m_TmcSerialColor.get_red_u() << '\t' << m_TmcSerialColor.get_green_u() << '\t'
            << m_TmcSerialColor.get_blue_u() << std::endl
            << m_TmcPasswordColor.get_red_u() << '\t' << m_TmcPasswordColor.get_green_u() << '\t'
            << m_TmcPasswordColor.get_blue_u() << std::endl
            << m_TmcUserDataColor.get_red_u() << '\t' << m_TmcUserDataColor.get_green_u() << '\t'
            << m_TmcUserDataColor.get_blue_u() << std::endl
            << m_TmcConfigColor.get_red_u() << '\t' << m_TmcConfigColor.get_green_u() << '\t'
            << m_TmcConfigColor.get_blue_u() << std::endl
            << std::dec << (uint)m_nTmcNewCardType << '\t' << m_rNewEmMarineUid.ToString() << '\t'
            << m_rNewHidUid.ToString() << std::endl
            << std::hex << m_McSerialColor.get_red_u() << '\t' << m_McSerialColor.get_green_u()
            << '\t' << m_McSerialColor.get_blue_u() << std::endl
            << m_McUserDataColor.get_red_u() << '\t' << m_McUserDataColor.get_green_u() << '\t'
            << m_McUserDataColor.get_blue_u() << std::endl
            << m_McUserDataRoColor.get_red_u() << '\t' << m_McUserDataRoColor.get_green_u() << '\t'
            << m_McUserDataRoColor.get_blue_u() << std::endl
            << m_McValueColor.get_red_u() << '\t' << m_McValueColor.get_green_u() << '\t'
            << m_McValueColor.get_blue_u() << std::endl
            << m_McValueDtrColor.get_red_u() << '\t' << m_McValueDtrColor.get_green_u() << '\t'
            << m_McValueDtrColor.get_blue_u() << std::endl
            << m_McNrwDataColor.get_red_u() << '\t' << m_McNrwDataColor.get_green_u() << '\t'
            << m_McNrwDataColor.get_blue_u() << std::endl
            << m_McAccessBitsColor.get_red_u() << '\t' << m_McAccessBitsColor.get_green_u() << '\t'
            << m_McAccessBitsColor.get_blue_u() << std::endl
            << m_McAccessBitsRoColor.get_red_u() << '\t' << m_McAccessBitsRoColor.get_green_u()
            << '\t' << m_McAccessBitsRoColor.get_blue_u() << std::endl
            << m_McKeyColor.get_red_u() << '\t' << m_McKeyColor.get_green_u() << '\t'
            << m_McKeyColor.get_blue_u() << std::endl
            << m_McNrwKeyColor.get_red_u() << '\t' << m_McNrwKeyColor.get_green_u() << '\t'
            << m_McNrwKeyColor.get_blue_u() << std::endl
            << m_McAuthKey.m_nKey << '\t' << m_fMfAuthRdKeys << '\t' << m_fMfAuthKeyB << std::endl
            << m_MpAuthKey.ll.hi << '\t' << m_MpAuthKey.ll.lo << std::endl
            << m_fMfOpenText << std::endl
            << m_MpEnColor.get_red_u() << '\t' << m_MpEnColor.get_green_u() << '\t'
            << m_MpEnColor.get_blue_u() << std::endl;
}

void CAppSetings::SetDebugLog(bool fValue) {
    if (m_fDebugLog == fValue)
        return;
    m_fDebugLog = fValue;
    m_fModified = true;
}

void CAppSetings::SetClearLogAtStartup(bool fValue) {
    if (m_fClearLogAtStartup == fValue)
        return;
    m_fClearLogAtStartup = fValue;
    m_fModified = true;
}

void CAppSetings::SetLogLevel(ilr_log_level nValue) {
    if (m_nLogLevel == nValue)
        return;
    m_nLogLevel = nValue;
    m_fModified = true;
}

void CAppSetings::SetReaderType(ilr_reader_types nType, bool fSet) {
    bool f = (m_nReaderTypes & nType) != 0;
    if (f == fSet)
        return;
    if (fSet)
        m_nReaderTypes |= nType;
    else
        m_nReaderTypes &= ~nType;
    m_fModified = true;
}

void CAppSetings::SetShowUnidentified(bool fValue) {
    if (m_fShowUnidentified == fValue)
        return;
    m_fShowUnidentified = fValue;
    m_fModified = true;
}

void CAppSetings::SetDataFormat(byte_format nValue) {
    if (m_nDataFormat == nValue)
        return;
    m_nDataFormat = nValue;
    m_fModified = true;
}

void CAppSetings::SetMfUlSerialColor(const Gdk::RGBA& Value) {
    if (m_MfUlSerialColor == Value)
        return;
    m_MfUlSerialColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMfUlLockColor(const Gdk::RGBA& Value) {
    if (m_MfUlLockColor == Value)
        return;
    m_MfUlLockColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMfUlLockRoColor(const Gdk::RGBA& Value) {
    if (m_MfUlLockRoColor == Value)
        return;
    m_MfUlLockRoColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMfUlUserDataColor(const Gdk::RGBA& Value) {
    if (m_MfUlUserDataColor == Value)
        return;
    m_MfUlUserDataColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMfUlUserDataRoColor(const Gdk::RGBA& Value) {
    if (m_MfUlUserDataRoColor == Value)
        return;
    m_MfUlUserDataRoColor = Value;
    m_fModified = true;
}

void CAppSetings::SetTmcSerialColor(const Gdk::RGBA& Value) {
    if (m_TmcSerialColor == Value)
        return;
    m_TmcSerialColor = Value;
    m_fModified = true;
}

void CAppSetings::SetTmcPasswordColor(const Gdk::RGBA& Value) {
    if (m_TmcPasswordColor == Value)
        return;
    m_TmcPasswordColor = Value;
    m_fModified = true;
}

void CAppSetings::SetTmcUserDataColor(const Gdk::RGBA& Value) {
    if (m_TmcUserDataColor == Value)
        return;
    m_TmcUserDataColor = Value;
    m_fModified = true;
}

void CAppSetings::SetTmcConfigColor(const Gdk::RGBA& Value) {
    if (m_TmcConfigColor == Value)
        return;
    m_TmcConfigColor = Value;
    m_fModified = true;
}

void CAppSetings::SetTemicNewCardType(ilr_card_type nCardType) {
    if (m_nTmcNewCardType == nCardType)
        return;
    m_nTmcNewCardType = nCardType;
    m_fModified = true;
}

void CAppSetings::SetTemicEmMarineUid(const ilr::CCardUID& rUid) {
    if (m_rNewEmMarineUid == rUid)
        return;
    m_rNewEmMarineUid = rUid;
    m_fModified = true;
}

void CAppSetings::SetTemicHidUid(const ilr::CCardUID& rUid) {
    if (m_rNewHidUid == rUid)
        return;
    m_rNewHidUid = rUid;
    m_fModified = true;
}

void CAppSetings::SetMcSerialColor(const Gdk::RGBA& Value) {
    if (m_McSerialColor == Value)
        return;
    m_McSerialColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcUserDataColor(const Gdk::RGBA& Value) {
    if (m_McUserDataColor == Value)
        return;
    m_McUserDataColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcUserDataRoColor(const Gdk::RGBA& Value) {
    if (m_McUserDataRoColor == Value)
        return;
    m_McUserDataRoColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcValueColor(const Gdk::RGBA& Value) {
    if (m_McValueColor == Value)
        return;
    m_McValueColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcValueDtrColor(const Gdk::RGBA& Value) {
    if (m_McValueDtrColor == Value)
        return;
    m_McValueDtrColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcNrwDataColor(const Gdk::RGBA& Value) {
    if (m_McNrwDataColor == Value)
        return;
    m_McNrwDataColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcAccessBitsColor(const Gdk::RGBA& Value) {
    if (m_McAccessBitsColor == Value)
        return;
    m_McAccessBitsColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcAccessBitsRoColor(const Gdk::RGBA& Value) {
    if (m_McAccessBitsRoColor == Value)
        return;
    m_McAccessBitsRoColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcKeyColor(const Gdk::RGBA& Value) {
    if (m_McKeyColor == Value)
        return;
    m_McKeyColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcNrwKeyColor(const Gdk::RGBA& Value) {
    if (m_McNrwKeyColor == Value)
        return;
    m_McNrwKeyColor = Value;
    m_fModified = true;
}

void CAppSetings::SetMcAuthKey(const ilr::CMifareClassicKey& Value) {
    if (m_McAuthKey == Value)
        return;
    m_McAuthKey = Value;
    m_fModified = true;
}

void CAppSetings::SetMfAuthRdKeys(bool fValue) {
    if (m_fMfAuthRdKeys == fValue)
        return;
    m_fMfAuthRdKeys = fValue;
    m_fModified = true;
}

void CAppSetings::SetMfAuthKeyB(bool fValue) {
    if (m_fMfAuthKeyB == fValue)
        return;
    m_fMfAuthKeyB = fValue;
    m_fModified = true;
}

void CAppSetings::SetMpAuthKey(const ilr::CMifarePlusKey& Value) {
    if (m_MpAuthKey == Value)
        return;
    m_MpAuthKey = Value;
    m_fModified = true;
}

void CAppSetings::SetMfOpenText(bool fValue) {
    if (m_fMfOpenText == fValue)
        return;
    m_fMfOpenText = fValue;
    m_fModified = true;
}

void CAppSetings::SetMpEnColor(const Gdk::RGBA& Value) {
    if (m_MpEnColor == Value)
        return;
    m_MpEnColor = Value;
    m_fModified = true;
}
