#pragma once
#include <gtkmm.h>

#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

class CTimeZoneDialog : public Gtk::Window {
public:
    CTimeZoneDialog();
    ~CTimeZoneDialog() override;

    void SetTzIdx(bool fModeTz, bool fOut, uint nIdx);

protected:
    void on_button_cancel();
    void on_button_ok();

    void UpdateCtrlData(bool fSave);

public:
    bool m_fModeTz;
    bool m_fOut;
    uint m_nIdx;
    ilg_time_zone m_rTz;
    ilg_mode_time_zone m_rModeTz;
    bool m_fAccept;

protected:
    ilg::CController m_oController;  // Контроллер

    Gtk::Grid m_Grid;
    Gtk::Frame m_DowsFrame;  // Группа "Дни недели"
    Gtk::Box m_DowsBox;
    Gtk::CheckButton m_aDowCheckButtons[7];
    Gtk::Frame m_TimeFrame;  // Группа "Время"
    Gtk::Box m_TimeBox;
    Gtk::Label m_FromLabel;
    Gtk::SpinButton m_aFromSpinButton[2];
    Glib::RefPtr<Gtk::Adjustment> m_refFromHourAdjustment;
    Glib::RefPtr<Gtk::Adjustment> m_refFromMinuteAdjustment;
    Gtk::Label m_FromSepLabel;
    Gtk::Label m_ToLabel;
    Gtk::Label m_ToSepLabel;
    Gtk::SpinButton m_aToSpinButton[2];
    Glib::RefPtr<Gtk::Adjustment> m_refToHourAdjustment;
    Glib::RefPtr<Gtk::Adjustment> m_refToMinuteAdjustment;
    Gtk::Frame m_ModeFrame;  // Группа "Режим"
    Glib::RefPtr<Gtk::StringList> m_refModeStringList;
    Gtk::DropDown m_ModeDropDown;  // Выпадающий список "Режим контроллера"
    Gtk::Box m_BottomBox;          // Нижняя панель с кнопками
    Gtk::Button m_CancelButton;  // Кнопка "Отмена"
    Gtk::Button m_OkButton;      // Кнопка "OK"
};
