#include "CProgressDialog.h"

#include <iostream>

CProgressDialog::CProgressDialog() :
    m_VBox(Gtk::Orientation::VERTICAL),
    m_StatusLabel("Выполнение..."),
    m_Button_Cancel("Отмена") {
    set_destroy_with_parent(true);

    set_title("Прогресс");
    set_default_size(450, 130);

    m_VBox.set_margin(5);
    set_child(m_VBox);

    m_VBox.append(m_StatusLabel);
    m_StatusLabel.set_expand(true);
    m_StatusLabel.set_halign(Gtk::Align::START);
    m_VBox.append(m_ProgressBar);
    m_ProgressBar.set_margin_end(5);
    m_ProgressBar.set_expand();
    m_ProgressBar.set_show_text(false);

    m_BottomBox.set_margin(5);
    m_BottomBox.set_expand(false);
    m_BottomBox.set_halign(Gtk::Align::CENTER);

    m_VBox.append(m_BottomBox);

    // Add a timer callback to update the value of the progress bar:
    m_connection_timeout =
        Glib::signal_timeout().connect(sigc::mem_fun(*this, &CProgressDialog::on_timeout), 333);

    m_BottomBox.append(m_Button_Cancel);
    m_Button_Cancel.set_halign(Gtk::Align::CENTER);
    m_Button_Cancel.signal_clicked().connect(
        sigc::mem_fun(*this, &CProgressDialog::on_button_cancel));
}

CProgressDialog::~CProgressDialog() {
}

void CProgressDialog::SetStatusText(const char* pText) {
    m_StatusLabel.set_text(pText);
}

void CProgressDialog::SetProgress(size_t nCurrent, size_t nTotal) {
    if (0 == nTotal)
        m_ProgressBar.pulse();
    else {
        auto new_val = (double)nCurrent / nTotal;
        m_ProgressBar.set_fraction(new_val);
    }
}

bool CProgressDialog::on_timeout() {
    size_t nCurrent, nTotal;
    if (m_signal_progress.empty() || !m_signal_progress.emit(nCurrent, nTotal))
        return false;
    SetProgress(nCurrent, nTotal);
    // As this is a timeout function, return true so that it continues to get called
    return true;
}

void CProgressDialog::on_button_cancel() {
    if (!m_signal_cancel.empty())
        m_signal_cancel.emit();
    set_visible(false);
}

CProgressDialog::type_signal_progress CProgressDialog::signal_progress() {
    return m_signal_progress;
}

CProgressDialog::type_signal_cancel CProgressDialog::signal_cancel() {
    return m_signal_cancel;
}
