#pragma once
#include "ilguard/ilguard.h"

// Формат номера ключа для редактирования
typedef enum {
    EDIT_KEY_FORMAT_DALLAS,     // Dallas
    EDIT_KEY_FORMAT_EM_MARINE,  // Em-Marine
    EDIT_KEY_FORMAT_KEYPAD,     // Код клавиатуры
    EDIT_KEY_FORMAT_SIZE        // Размер списка
} edit_key_format;

typedef struct MyKeyNumber {
    ilg_key_number m_Number;
    uint8_t m_nFlags;
    bool m_fEmpty;

    MyKeyNumber() :
        m_Number(),
        m_nFlags(0),
        m_fEmpty(true) {
    }

    MyKeyNumber(const ilg_key_number& number, uint8_t nFlags) :
        m_Number(number),
        m_nFlags(nFlags),
        m_fEmpty(false) {
    }
} MyKeyNumber;
