#include <fstream>   // для std::fstream
#include <iomanip>   // для std::put_time
#include <iostream>  // для std::cout и std::cin

#include "ilg_cpp_helpers.h"
#include "ilguard.h"

// #define ILG_LOG  // Раскомментируйте, чтобы включить показ отладочных сообщений
#define ILG_LOG_FILE  // Писать лог в файл

using namespace ilg;

#ifdef ILG_LOG
const char kLogLevelChars[] = {'-', 'E', 'W', 'I', 'D'};
const char kLogFileName[] = "ilguard.log";  // Путь к лог файлу

void ILG_CALL LogCallback(ilg_log_level level, const char* pContext, const char* pMessage, void*) {
#if 1  // Запись в файл
    std::fstream file(kLogFileName, std::ios_base::out | std::ios_base::app);
    auto& out = file;
#else  // иначе в консоль
    auto& out = std::cout;
#endif
    auto t = std::time(nullptr);
    auto tmb = std::localtime(&t);
    out << std::put_time(tmb, "%d-%m-%Y %H:%M:%S") << " [" << kLogLevelChars[level] << ' '
        << pContext << "] " << pMessage << std::endl;
}
#endif

int main() {
    std::cout << "Версия SDK: " << SdkVersionToStr(CILG::GetVersion()) << std::endl;

    try {
#ifdef ILG_LOG
#ifdef ILG_LOG_FILE
        // Очищаем лог файл
        std::ofstream file(kLogFileName, std::ios_base::out | std::ios_base::trunc);
        file.close();
#endif
        // Включаем лог отладки
        CILG::SetLogCallback(LogCallback);
        CILG::SetLogLevel(ILG_LOG_LEVEL_DEBUG);
#endif

        CILG oILR;
        CConverterSearch oSearch(oILR.GetSearch());

#if 0
        // Выбираем типы конвертеров для поиска
        ilg_search_options rOptions;
        oSearch.GetOptions(rOptions);
        rOptions.nConverterTypes =
            ILG_CONVERTER_ILUSB | ILG_CONVERTER_SERVER | ILG_CONVERTER_CLIENT;
        oSearch.SetOptions(rOptions);

        // Включаем поиск конвертеров в режиме "Клиент"
        const uint16_t aListenPorts[] = {25000};
        oSearch.SetListenPorts(aListenPorts, std::size(aListenPorts));
#endif
        // Ищем конвертеры
        std::cout << "Поиск конвертеров..." << std::endl;
        oSearch.Scan();
        auto nCount = oSearch.GetConverterCount();
        if (nCount != 0) {
            std::cout << "Найдено " << nCount << ':' << std::endl;
            ilg_converter_info rInfo;
            for (size_t i = 0; i < nCount; i++) {
                oSearch.GetConverterInfo(i, rInfo);
                std::stringstream ss;
                if (rInfo.nModel != ILG_CONVERTER_MODEL_UNKNOWN)
                    ss << kConverterModelNames[rInfo.nModel];
                if (rInfo.nSn != -1)
                    ss << " с/н:" << rInfo.nSn;
                if (rInfo.nFwVersion != 0)
                    ss << " прошивка:" << VersionToStr(rInfo.nFwVersion);
                if (rInfo.nFwBuildDate != 0)
                    ss << " сборка " << TimeToStr(rInfo.nFwBuildDate);
                if (rInfo.nMode != ILG_CONVERTER_MODE_UNKNOWN)
                    ss << " режим: " << kConverterModeNames[rInfo.nMode];
                std::cout << 1 + i << ". " << rInfo.pszPortName << ": " << ss.str() << std::endl;
            }
        }
        else
            std::cout << "Конвертеры не найдены" << std::endl;
    }
    catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }
    return 0;
}
