#pragma once
#include <gtkmm.h>

#include "CTimeZoneDialog.h"
#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

class CScheduleDialog : public Gtk::Window {
public:
    CScheduleDialog();
    ~CScheduleDialog() override;

    void Init(const ilg::CController& oController);

protected:
    void on_button_sync();
    void on_button_auto_sync();
    bool on_timeout();
    void on_dialog_response(int);
    void on_in_tz_row_activated(Gtk::ListBoxRow* pRow);
    void on_out_tz_row_activated(Gtk::ListBoxRow* pRow);
    void on_mode_tz_row_activated(Gtk::ListBoxRow* pRow);
    void on_tz_dialog_hide();

    void UpdateClock(bool fForce = false);
    void CheckClock();
    std::string TimeToStr(time_t t);
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);
    void UpdateInTzView();
    void UpdateInTzRow(size_t nIdx);
    void UpdateOutTzView();
    void UpdateOutTzRow(size_t nIdx);
    void UpdateModeTzView();
    void UpdateModeTzRow(size_t nIdx);
    void DoChangeTz(bool fOut, size_t nIdx);
    void DoChangeModeTz(size_t nIdx);

protected:
    class CMyListRow : public Gtk::ListBoxRow {
    public:
        CMyListRow(const std::string& text) :
            m_Label(text) {
            set_child(m_Label);
            set_halign(Gtk::Align::START);
            m_Label.set_size_request(150);
        }

        void set_text(const std::string& text) {
            m_Label.set_label(text);
        }

    protected:
        Gtk::Label m_Label;
    };

    ilg::CController m_oController;  // Контроллер
    bool m_fClockValid;
    int64_t m_nCtrTimeSpan;
    time_t m_tCtrTime;
    time_t m_tPcTime;
    bool m_fClockFilled;
    uint m_nClockUpdateCounter;
    ilg_time_zone m_aInTzs[7];
    ilg_time_zone m_aOutTzs[7];
    ilg_mode_time_zone m_aModeTzs[2];

    Gtk::Box m_VBox;          // Основная панель
    Gtk::Frame m_ClockFrame;  // Группа "Часы контроллера"
    Gtk::Grid m_ClockGrid;
    Gtk::Label m_CtrTimeLabel;  // Метка "Время контроллера"
    Gtk::Label m_PcTimeLabel;   // Метка "Время ПК"
    Gtk::Entry m_CtrTimeEntry;
    Gtk::Entry m_PcTimeEntry;
    Gtk::Button m_SyncButton;                // Кнопка "Синхронизировать"
    Gtk::CheckButton m_AutoSyncCheckButton;  // Флажок "Авто синхронизация (>=5 с)"
    sigc::connection m_connection_timeout;
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;
    Gtk::Frame m_TzFrame;  // Группа "Временные зоны"
    Gtk::Grid m_TzGrid;
    Gtk::Frame m_InTzFrame;  // Группа "Вход"
    Gtk::ListBox m_InTzListBox;
    CMyListRow m_aInTzRows[7];
    Gtk::Frame m_OutTzFrame;  // Группа "Выход"
    Gtk::ListBox m_OutTzListBox;
    CMyListRow m_aOutTzRows[7];
    Gtk::Frame m_ModeTzFrame;  // Группа "Переключение режима контроллера"
    Gtk::ListBox m_ModeTzListBox;
    CMyListRow m_aModeTzRows[2];
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Glib::RefPtr<CTimeZoneDialog> m_refTimeZoneDialog;
};
