#pragma once
#include <gtkmm.h>

class CProgressDialog : public Gtk::Window {
public:
    // signal accessor:
    using type_signal_progress = sigc::signal<bool(size_t&, size_t&)>;
    using type_signal_cancel = sigc::signal<void()>;

public:
    CProgressDialog();
    ~CProgressDialog() override;

    void SetStatusText(const char* pText);
    void SetProgress(size_t nCurrent, size_t nTotal);

    type_signal_progress signal_progress();
    type_signal_cancel signal_cancel();

protected:
    bool on_timeout();
    void on_button_cancel();

protected:
    Gtk::Box m_VBox;  // Основная панель
    Gtk::Label m_StatusLabel;
    Gtk::ProgressBar m_ProgressBar;
    Gtk::Box m_BottomBox;  // Нижняя панель
    Gtk::Button m_Button_Cancel;
    sigc::connection m_connection_timeout;
    type_signal_progress m_signal_progress;
    type_signal_cancel m_signal_cancel;
};