#include "CLockDialog.h"

CLockDialog::CLockDialog() :
    m_nBankCount(1),
    m_fApbEnabled(false),
    m_nApbMinutes(0),
    m_fEmergencyMode(false),
    m_VBox(Gtk::Orientation::VERTICAL),
    m_TimesFrame("Времена замка"),
    m_InLabel("Вход"),
    m_OutLabel("Выход"),
    m_BigTimeLabel("Большое время:"),
    m_In2OutButton(">>"),
    m_Out2InButton("<<"),
    m_ResetTimesButton("По умолчанию"),
    m_ApbTimeFrame("Время антипассбэк"),
    m_ApbTimeBox(Gtk::Orientation::VERTICAL),
    m_ApbCheckButton("Включено"),
    m_ApbLabel("Время (минут):", Gtk::Align::END),
    m_refApbAdjustment(Gtk::Adjustment::create(0, 0, 65535.0, 1.0)),
    m_ApbSpinButton(m_refApbAdjustment),
    m_EmergencyCheckButton("Аварийное открывание (старая команда)"),
    m_CancelButton("Отмена"),
    m_OkButton("OK") {
    set_destroy_with_parent(true);
    set_title("Замок");
    set_default_size(600, 480);

    memset(m_aTimes, 0, sizeof(m_aTimes));

    m_VBox.set_margin(5);
    set_child(m_VBox);

    m_VBox.append(m_TimesFrame);
    m_VBox.append(m_ApbTimeFrame);
    m_VBox.append(m_EmergencyCheckButton);
    m_VBox.append(m_BottomBox);

    m_TimesFrame.set_child(m_TimesGrid);

    for (size_t i = 0; i < 2; i++) {
        for (size_t j = 0; j < 3; j++) {
            m_refTimesAdjustment[i][j] = Gtk::Adjustment::create(0, 0, 25.5, 0.1, 1.0);
            auto& oSpinButton = m_aTimesSpinButtons[i][j];
            oSpinButton.set_adjustment(m_refTimesAdjustment[i][j]);
            oSpinButton.set_digits(1);
            oSpinButton.set_size_request(150);
        }
    }

    m_TimesGrid.set_margin(5);
    m_TimesGrid.set_row_spacing(10);
    m_TimesGrid.set_column_spacing(10);
    m_TimesGrid.attach(m_InLabel, 1, 0);
    m_TimesGrid.attach(m_OutLabel, 3, 0);
    m_TimesGrid.attach_next_to(m_aTimeLabels[0], Gtk::PositionType::BOTTOM);
    m_TimesGrid.attach(m_aTimesSpinButtons[0][0], 1, 1);
    m_TimesGrid.attach(m_aTimesSpinButtons[1][0], 3, 1);
    m_TimesGrid.attach_next_to(m_aTimeLabels[1], Gtk::PositionType::BOTTOM);
    m_TimesGrid.attach(m_aTimesSpinButtons[0][1], 1, 2);
    m_TimesGrid.attach(m_aTimesSpinButtons[1][1], 3, 2);
    m_TimesGrid.attach(m_In2OutButton, 2, 2);
    m_TimesGrid.attach_next_to(m_aTimeLabels[2], Gtk::PositionType::BOTTOM);
    m_TimesGrid.attach(m_aTimesSpinButtons[0][2], 1, 3);
    m_TimesGrid.attach(m_aTimesSpinButtons[1][2], 3, 3);
    m_TimesGrid.attach(m_Out2InButton, 2, 3);
    m_TimesGrid.attach_next_to(m_BigTimeLabel, Gtk::PositionType::BOTTOM);
    m_TimesGrid.attach(m_aBigTimeCheckButtons[0], 1, 4);
    m_TimesGrid.attach(m_aBigTimeCheckButtons[1], 3, 4);
    m_TimesGrid.attach_next_to(m_ResetTimesButton, Gtk::PositionType::BOTTOM);

    m_aTimeLabels[0].set_label("Время открытия (0.1 с):");
    m_aTimeLabels[1].set_label("Время контроля открытия (0.1 с):");
    m_aTimeLabels[2].set_label("Время контроля закрытия (0.1 с):");
    for (size_t i = 0; i < 3; i++)
        m_aTimeLabels[i].set_halign(Gtk::Align::END);
    m_BigTimeLabel.set_halign(Gtk::Align::END);

    m_In2OutButton.signal_clicked().connect(sigc::mem_fun(*this, &CLockDialog::on_button_in2out));
    m_Out2InButton.signal_clicked().connect(sigc::mem_fun(*this, &CLockDialog::on_button_out2in));
    m_aBigTimeCheckButtons[0].signal_toggled().connect(
        sigc::mem_fun(*this, &CLockDialog::on_button_bigtime0));
    m_aBigTimeCheckButtons[1].signal_toggled().connect(
        sigc::mem_fun(*this, &CLockDialog::on_button_bigtime1));
    m_ResetTimesButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CLockDialog::on_button_reset_times));

    m_ApbTimeFrame.set_child(m_ApbTimeBox);
    m_ApbTimeBox.set_margin(5);
    m_ApbTimeBox.append(m_ApbCheckButton);
    m_ApbTimeBox.append(m_ApbBox);
    m_ApbBox.set_margin(5);
    m_ApbBox.set_expand(false);
    m_ApbBox.append(m_ApbLabel);
    m_ApbBox.append(m_ApbSpinButton);
    m_ApbSpinButton.set_wrap();
    m_ApbSpinButton.set_size_request(55, -1);

    m_BottomBox.set_margin(5);
    m_BottomBox.set_spacing(5);
    m_BottomBox.append(m_CancelButton);
    m_BottomBox.append(m_OkButton);
    m_BottomBox.set_valign(Gtk::Align::END);
    m_BottomBox.set_vexpand(true);
    m_BottomBox.set_halign(Gtk::Align::END);

    m_CancelButton.signal_clicked().connect(sigc::mem_fun(*this, &CLockDialog::on_button_cancel));
    m_OkButton.signal_clicked().connect(sigc::mem_fun(*this, &CLockDialog::on_button_ok));
}

CLockDialog::~CLockDialog() {
    m_oController = nullptr;
}

void CLockDialog::Init(const ilg::CController& oController) {
    m_oController = oController.Clone();

    ilg_controller_info rInfo;
    m_oController.GetControllerInfo(rInfo);
    m_ApbTimeFrame.set_visible((rInfo.nCtrFlags & ILG_CTR_F_APB) != 0);
    auto f = (rInfo.nCtrFlags & ILG_CTR_F_BIGTIME) != 0;
    m_BigTimeLabel.set_visible(f);
    for (size_t i = 0; i < std::size(m_aBigTimeCheckButtons); i++)
        m_aBigTimeCheckButtons[i].set_visible(f);

    m_nBankCount = (rInfo.nCtrFlags & ILG_CTR_F_TWOBANKS) ? 2 : 1;
    for (size_t i = 0; i < m_nBankCount; i++)
        m_oController.ReadLockTimes(i, m_aTimes[i][0], m_aTimes[i][1], m_aTimes[i][2],
                                    m_aBigTime[i]);
    f = (2 == m_nBankCount);
    m_OutLabel.set_visible(f);
    m_In2OutButton.set_visible(f);
    m_Out2InButton.set_visible(f);
    for (size_t i = 0; i < 3; i++)
        m_aTimesSpinButtons[1][i].set_visible(f);
    m_aBigTimeCheckButtons[1].set_visible(f);

    if (rInfo.nCtrFlags & ILG_CTR_F_APB)
        m_oController.ReadApbTime(m_fApbEnabled, m_nApbMinutes);

    f = (rInfo.nCtrFlags & ILG_CTR_F_OLDEMERGOPEN) != 0;
    m_EmergencyCheckButton.set_visible(f);
    if (f) {
        ilg_rtc_params rRtc;
        m_oController.ReadRtcParams(rRtc);
        m_fEmergencyMode = static_cast<bool>(rRtc.fEmergencyOpen);
    }
    if (2 == m_nBankCount)
        m_InLabel.set_label("Вход");
    else
        m_InLabel.set_label("Вход и выход");
    UpdateCtrlData(false);
}

void CLockDialog::on_button_cancel() {
    set_visible(false);
}

void CLockDialog::on_button_ok() {
    UpdateCtrlData(true);

    try {
        for (size_t i = 0; i < m_nBankCount; i++)
            m_oController.WriteLockTimes(i, m_aTimes[i][0], m_aTimes[i][1], m_aTimes[i][2],
                                         m_aBigTime[i]);

        if (m_ApbTimeFrame.get_visible())
            m_oController.WriteApbTime(m_fApbEnabled, m_nApbMinutes);
        m_oController.SetEmergencyMode(m_fEmergencyMode);
    }
    catch (const std::exception& e) {
        ShowMessage(e.what());
        return;
    }

    set_visible(false);
}

void CLockDialog::on_button_in2out() {
    UpdateCtrlData(true);
    for (size_t i = 0; i < 3; i++)
        m_aTimes[1][i] = m_aTimes[0][i];
    UpdateCtrlData(false);
}

void CLockDialog::on_button_out2in() {
    UpdateCtrlData(true);
    for (size_t i = 0; i < 3; i++)
        m_aTimes[0][i] = m_aTimes[1][i];
    UpdateCtrlData(false);
}

void CLockDialog::on_button_bigtime0() {
    auto fBigTime = m_aBigTimeCheckButtons[0].get_active();
    if (m_aBigTime[0] == fBigTime)
        return;
    m_aBigTime[0] = fBigTime;
    auto m = fBigTime ? 6553.5 : 25.5;
    for (size_t i = 0; i < 3; i++) {
        m_aTimes[0][i] = m_aTimesSpinButtons[0][i].get_value() * 10;
        auto v = (double)m_aTimes[0][i] / 10;
        m_refTimesAdjustment[0][i]->configure(v, 0, m, 0.1, 1.0, 0);
        // m_aTimesSpinButtons[0][i].set_value(v);
    }
}

void CLockDialog::on_button_bigtime1() {
    auto fBigTime = m_aBigTimeCheckButtons[1].get_active();
    if (m_aBigTime[1] == fBigTime)
        return;
    m_aBigTime[1] = fBigTime;
    auto m = fBigTime ? 6553.5 : 25.5;
    for (size_t i = 0; i < 3; i++) {
        m_aTimes[1][i] = m_aTimesSpinButtons[1][i].get_value() * 10;
        auto v = (double)m_aTimes[1][i] / 10;
        m_refTimesAdjustment[1][i]->configure(v, 0, m, 0.1, 1.0, 0);
        // m_aTimesSpinButtons[1][i].set_value(v);
    }
}

void CLockDialog::on_button_reset_times() {
    UpdateCtrlData(true);
    for (size_t i = 0; i < m_nBankCount; i++) {
        m_aBigTime[i] = false;
        m_aTimes[i][0] = 3;
        m_aTimes[i][1] = 0;
        m_aTimes[i][2] = 0;
    }
    UpdateCtrlData(false);
}

void CLockDialog::on_dialog_response(int) {
    m_refDialog = nullptr;
}

void CLockDialog::UpdateCtrlData(bool fSave) {
    if (fSave) {
        for (size_t i = 0; i < m_nBankCount; i++) {
            for (size_t j = 0; j < 3; j++) {
                m_aTimes[i][j] = m_aTimesSpinButtons[i][j].get_value() * 10;
            }
        }
        m_fApbEnabled = m_ApbCheckButton.get_active();
        m_nApbMinutes = static_cast<uint16_t>(m_ApbSpinButton.get_value_as_int());
        m_fEmergencyMode = m_EmergencyCheckButton.get_active();
    }
    else {
        for (size_t i = 0; i < m_nBankCount; i++) {
            auto m = m_aBigTime[i] ? 6553.5 : 25.5;
            for (size_t j = 0; j < 3; j++) {
                auto v = (double)m_aTimes[i][j] / 10;
                m_refTimesAdjustment[i][j]->configure(v, 0, m, 0.1, 1.0, 0);
                // m_aTimesSpinButtons[i][j].set_value(v);
            }
        }
        m_ApbCheckButton.set_active(m_fApbEnabled);
        m_ApbSpinButton.set_value(m_nApbMinutes);
        m_EmergencyCheckButton.set_active(m_fEmergencyMode);
    }
}

void CLockDialog::ShowMessage(const std::string& sMessage, Gtk::MessageType nType) {
    if (nullptr == m_refDialog)
        m_refDialog.reset(new Gtk::MessageDialog("Демо", false, nType));
    m_refDialog->set_transient_for(*this);
    m_refDialog->set_message(sMessage);
    m_refDialog->show();
    m_refDialog->signal_response().connect(
        sigc::bind(sigc::mem_fun(*this, &CLockDialog::on_dialog_response)));
}
