#pragma once
#include <gtkmm.h>

#include "CTimeZoneDialog.h"
#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

/**
 * Окно "Режим ЭлектроКонтроль" для настройки управления электропитанием
 */
class CEcDialog : public Gtk::Window {
public:
    CEcDialog();
    ~CEcDialog() override;

    void Init(const ilg::CController& oController);

protected:
    void on_button_enabled();
    void on_button_schedule();
    bool on_schedule_label_link(const Glib::ustring& uri);
    void on_tz_dialog_hide();
    void on_button_read();
    void on_button_write();

    void DoRead();
    void DoWrite();
    void DoChangeSchedule();
    void UpdateCtrlData(bool fSave);
    void UpdateScheduleLabel();
    void UpdateCtrlState();

protected:
    ilg::CController m_oController;  // Контроллер
    ilg_time_zone m_rTz;             // Временная зона №7 (считая от 1)

    Gtk::Box m_Box;
    Gtk::CheckButton m_EnableCheckButton;  // Флажок "Активировать управление питанием"
    Gtk::CheckButton m_ExtReaderCheckButton;  // Флажок "Внешний контрольный считыватель"
    Gtk::CheckButton
        m_CardOpenCheckButton;  // Флажок "Не блокировать функцию открывания двери ключом"
    Gtk::CheckButton m_ExitOffCheckButton;  // Флажок "По датчику двери выключать немедленно при
                                            // выходе из комнаты"
    Gtk::Label m_DelayLabel;  // Метка "Задержка на выключение (сек):"
    Glib::RefPtr<Gtk::Adjustment> m_refDelayAdjustment;
    Gtk::SpinButton m_DelaySpinButton;
    Gtk::CheckButton m_InvertCheckButton;  // Флажок "Включение питания нулевым уровнем"
    Gtk::CheckButton m_ScheduleCheckButton;  // Флажок "Использовать расписание временной зоны #7"
    Gtk::Label m_ScheduleLabel;
    Gtk::Box m_BottomBox;
    Gtk::Button m_ReadButton;   // Кнопка "Читать"
    Gtk::Button m_WriteButton;  // Кнопка "Записать"
    Glib::RefPtr<CTimeZoneDialog> m_refTimeZoneDialog;
};
