#pragma once
#include <gtkmm.h>

#include <filesystem>

#include "CControllerDialog.h"
#include "CProgressDialog.h"
#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

class CConverterDialog : public Gtk::Window {
public:
    CConverterDialog();
    ~CConverterDialog() override;

    void SetConverter(ilg::CConverter& oConverter);
    bool DoCtrOpen();

protected:
    void on_button_connect();
    void on_button_disconnect();
    void on_button_setfw();
    void on_fw_dialog_response(int response_id, Gtk::FileChooserDialog* dialog);
    void on_progress_dialog_cancel();
    bool on_progress_dialog_progress(size_t& nCurrent, size_t& nTotal);
    void on_progress_dialog_hide();
    void on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item, Gtk::Align halign);
    void on_bind_address(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_model(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_sn(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_fwversion(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_readermode(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_menu_ctrs_autoscan();
    void on_menu_ctrs_reassign01();
    void on_menu_ctrs_netctrs();
    void on_menu_ctrs_elock();
    void on_menu_scanmeth(int parameter);
    void on_menu_ctrs_refresh();
    void on_ctr_selection_changed(guint, guint);
    void on_ctr_columnview_rclick(int n_press, double x, double y);
    void on_ctr_columnview_activate(guint n);
    void on_button_ctr_open();
    void on_controller_dialog_hide();
    void on_bind_license(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_controllers(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_keys(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_expdate(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_minutes(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_button_lic_read();
    void on_button_lic_set();
    void on_button_lic_clear();
    void on_lic_dialog_response(int response_id, Gtk::FileChooserDialog* dialog);
    void on_dialog_response(int);
    void on_notebook_switch_page(Gtk::Widget* page, guint page_num);
    static void ILG_CALL on_ilg_message(ilg_converter_msg nMsg, const void* pMsgData,
                                        void* pUserData);
    void on_ilg();

    void UpdateConnectionStatus();
    void UpdateConverterInfo();
    void UpdateControllers();
    void UpdateCtrButtonsState();
    void UpdateLicenses();
    void LoadSettings();
    void SaveSettings();
    std::filesystem::path GetSettingFilePath() const;
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);

protected:
    // A Gio::ListStore item.
    class CtrModelColumns : public Glib::Object {
    public:
        uint32_t m_nAddress;
        ilg_controller_model m_nModel;
        int m_nSn;
        uint m_nFwVersion;
        bool m_fWiegand;

        static Glib::RefPtr<CtrModelColumns> create(uint32_t nAddress, ilg_controller_model nModel,
                                                    int nSn, uint nFwVersion, bool fWiegand) {
            return Glib::make_refptr_for_instance<CtrModelColumns>(
                new CtrModelColumns(nAddress, nModel, nSn, nFwVersion, fWiegand));
        }

    protected:
        CtrModelColumns(uint32_t nAddress, ilg_controller_model nModel, int nSn, uint nFwVersion,
                        bool fWiegand) :
            m_nAddress(nAddress),
            m_nModel(nModel),
            m_nSn(nSn),
            m_nFwVersion(nFwVersion),
            m_fWiegand(fWiegand) {
        }
    };  // CtrModelColumns

    class LicModelColumns : public Glib::Object {
    public:
        uint32_t m_nLicenseN;
        uint16_t m_nControllers;
        uint16_t m_nKeys;
        uint16_t m_nExpDate;
        uint16_t m_nMinutes;

        static Glib::RefPtr<LicModelColumns> create(uint32_t nLicenseN, uint16_t nControllers,
                                                    uint16_t nKeys, uint16_t nExpDate,
                                                    uint16_t nMinutes) {
            return Glib::make_refptr_for_instance<LicModelColumns>(
                new LicModelColumns(nLicenseN, nControllers, nKeys, nExpDate, nMinutes));
        }

    protected:
        LicModelColumns(uint32_t nLicenseN, uint16_t nControllers, uint16_t nKeys,
                        uint16_t nExpDate, uint16_t nMinutes) :
            m_nLicenseN(nLicenseN),
            m_nControllers(nControllers),
            m_nKeys(nKeys),
            m_nExpDate(nExpDate),
            m_nMinutes(nMinutes) {
        }
    };  // LicModelColumns

    ilg::CConverter m_oConverter;  // Конвертер
    ilg::CAsyncCommand m_oCommand;
    Glib::Dispatcher m_oDisp;  // Для синхронизации Callback-функций SDK Guard

    Gtk::Box m_VBox;    // Основная панель
    Gtk::Box m_TopBox;  // Верхняя панель
    Gtk::Box m_StatusBox;  // Панель внутри группы "Состояние подключения"
    Gtk::Frame m_StatusFrame;  // Группа "Состояние подключения"
    Gtk::Label m_StatusLabel;  // Текстовая метка в группе "Состояние подключения"
    Gtk::Button m_ConnectButton;     // Кнопка "Подключиться"
    Gtk::Button m_DisconnectButton;  // Кнопка "Отключиться"
    Gtk::Button m_SetFwButton;       // Кнопка "Установить прошивку"
    Gtk::Notebook m_Notebook;        // Вкладки
    Glib::RefPtr<Gtk::Builder> m_refBuilder;
    Glib::RefPtr<Gtk::GestureClick> m_refGesture;
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Glib::RefPtr<CProgressDialog> m_refProgressDialog;

    // Вкладка "Контроллеры"

    Gtk::Box m_CtrsBox;  // Панель вкладки "Контроллеры"
    Gtk::ScrolledWindow m_CtrScrolledWindow;
    Gtk::ColumnView m_CtrColumnView;
    Glib::RefPtr<Gio::ListStore<CtrModelColumns>> m_CtrListStore;
    Gtk::PopoverMenu m_CtrMenuPopup;
    Gtk::Box m_CtrBtnsBox;  // Панель кнопок на панели "Контроллеры"
    Gtk::Button m_CtrOpenButton;
    Glib::RefPtr<Gio::SimpleAction> m_refAutoScanAction;
    Glib::RefPtr<Gio::SimpleAction> m_refReassign01Action;
    Glib::RefPtr<Gio::SimpleAction> m_refNetCtrsAction;
    Glib::RefPtr<Gio::SimpleAction> m_refELockAction;
    Glib::RefPtr<Gio::SimpleAction> m_refScanMethAction;
    CControllerDialog m_oCtrDlg;

    // Вкладка "Лицензии"

    Gtk::Box m_LicsBox;  // Панель вкладки "Лицензии"
    Gtk::ScrolledWindow m_LicScrolledWindow;
    Gtk::ColumnView m_LicColumnView;
    Glib::RefPtr<Gio::ListStore<LicModelColumns>> m_LicListStore;
    Gtk::Box m_LicBtnsBox;  // Панель кнопок на панели "Лицензии"
    Gtk::Button m_LicReadButton;
    Gtk::Button m_LicSetButton;
    Gtk::Button m_LicClearButton;

    int m_nConverterSn;        // Серийный номер конвертера
    bool m_fSettingsModified;  // true, настройки конвертера изменены
    bool m_fLicensesInit;      // true, список лицензий инициализирован

    friend void ILG_CALL on_ilg_message(ilg_converter_msg nMsg, const void* pMsgData,
                                        void* pUserData);
};
