#pragma once
#include <filesystem>

#include "types.h"

class CTemicReaderSettings {
public:
    bool m_fModified;         // true, настройки считывателя изменены
    bool m_fTemicAutoScan;    // true, включено авто сканирование Temic
    int m_nTemicScanParam;    // Параметры сканирования Temic
    bool m_fTemicPswEnabled;  // True, использоваться пароль Temic
    uint m_nTemicPassword;    // Пароль Temic

public:
    CTemicReaderSettings();

    void Load(const std::filesystem::path& path);
    void Save(const std::filesystem::path& path);

    inline void SetModifiedFlag(bool fModified = true);
    void SetTemicPswEnabled(bool fEnabled);
    void SetTemicPassword(uint nPassword);
    void SetTemicScanParam(int nValue);
};

inline void CTemicReaderSettings::SetModifiedFlag(bool fModified) {
    m_fModified = fModified;
}
