#include "CTemicPasswordsSettings.h"

#include <fstream>

CTemicPasswordsSettings::CTemicPasswordsSettings() :
    m_fModified(false) {
}

void CTemicPasswordsSettings::Load(const std::filesystem::path& path) {
    m_fModified = false;
    m_oPasswords.clear();
    if (std::filesystem::exists(path)) {
        std::ifstream inFile;
        inFile.open(path);
        inFile >> std::hex;
        CTemicPassword r;
        while (true) {
            inFile >> r.m_nPassword >> std::quoted(r.m_sComment);
            if (!inFile.good())
                break;
            m_oPasswords.emplace_back(std::move(r));
        }
    }
}

void CTemicPasswordsSettings::Save(const std::filesystem::path& path) {
    std::ofstream outFile;
    outFile.open(path);
    outFile.imbue(std::locale("C"));
    outFile << std::hex;
    for (auto& r : m_oPasswords) {
        outFile << r.m_nPassword << '\t' << std::quoted(r.m_sComment) << std::endl;
    }
    m_fModified = false;
}
