#include "CMfSecurityLevelDialog.h"

#include <chrono>
#include <sstream>
#include <thread>

#define HAS_STYLE_PROVIDER_ADD_PROVIDER_FOR_DISPLAY GTKMM_CHECK_VERSION(4, 9, 1)

CMfSecurityLevelDialog::CMfSecurityLevelDialog() :
    m_fMasterKeyOk(false),
    m_fConfigKeyOk(false),
    m_fL2SwitchKeyOk(false),
    m_fL3SwitchKeyOk(false),
    m_fAuthL3SwitchKeyOk(false),
    m_VBox(Gtk::Orientation::VERTICAL),
    m_CardFrame("Текущая карта"),
    m_CardRefreshButton("Обновить"),
    m_SL0Frame("Переключение SL0 -> в SL1 или SL3"),
    m_MasterKeyLabel("Master Key:"),
    m_ConfigKeyLabel("Configuration Key:"),
    m_L2SwitchKeyLabel("Level 2 Switch Key:"),
    m_L3SwitchKeyLabel("Level 3 Switch Key:"),
    m_SwitchSL1Button("Переключить в SL1"),
    m_SL1Frame("Переключение SL1 -> в SL3"),
    m_AuthL3SwitchKeyLabel("Level 3 Switch Key:"),
    m_SwitchSL3Button("Переключить в SL3") {
    set_destroy_with_parent(true);

    set_title("Уровень безопасности карты Mifare Plus");
    set_default_size(600, 450);

    set_child(m_VBox);
    m_VBox.set_margin(5);
    m_VBox.set_expand();
    m_VBox.append(m_CardFrame);
    m_VBox.append(m_SL0Frame);
    m_VBox.append(m_SL1Frame);

    m_CardFrame.set_child(m_CardBox);
    m_CardBox.set_margin(5);
    m_CardBox.append(m_CardLabel);
    m_CardBox.append(m_CardRefreshButton);
    m_CardLabel.set_hexpand();
    m_CardLabel.set_halign(Gtk::Align::START);
    m_CardRefreshButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CMfSecurityLevelDialog::on_button_card_refresh));

    m_SL0Frame.set_child(m_SL0Grid);
    m_SL0Grid.set_margin(5);
    m_SL0Grid.set_column_spacing(5);
    m_SL0Grid.set_row_spacing(5);
    m_SL0Grid.attach(m_MasterKeyLabel, 0, 0);
    m_SL0Grid.attach(m_MasterKeyEntry, 0, 1);
    m_SL0Grid.attach(m_ConfigKeyLabel, 0, 2);
    m_SL0Grid.attach(m_ConfigKeyEntry, 0, 3);
    m_SL0Grid.attach(m_L2SwitchKeyLabel, 0, 4);
    m_SL0Grid.attach(m_L2SwitchKeyEntry, 0, 5);
    m_SL0Grid.attach(m_L3SwitchKeyLabel, 0, 6);
    m_SL0Grid.attach(m_L3SwitchKeyEntry, 0, 7);
    m_SL0Grid.attach_next_to(m_SwitchSL1Button, Gtk::PositionType::BOTTOM);
    m_MasterKeyLabel.set_halign(Gtk::Align::START);
    m_MasterKeyEntry.set_hexpand();
    m_ConfigKeyLabel.set_halign(Gtk::Align::START);
    m_ConfigKeyEntry.set_hexpand();
    m_L2SwitchKeyLabel.set_halign(Gtk::Align::START);
    m_L2SwitchKeyEntry.set_hexpand();
    m_L3SwitchKeyLabel.set_halign(Gtk::Align::START);
    m_L3SwitchKeyEntry.set_hexpand();
    m_SwitchSL1Button.set_halign(Gtk::Align::END);
    m_SwitchSL1Button.signal_clicked().connect(
        sigc::mem_fun(*this, &CMfSecurityLevelDialog::on_button_switch_sl1));

    m_SL1Frame.set_child(m_SL1Grid);
    m_SL1Grid.set_margin(5);
    m_SL1Grid.set_column_spacing(5);
    m_SL1Grid.set_row_spacing(5);
    m_SL1Grid.attach(m_AuthL3SwitchKeyLabel, 0, 0);
    m_SL1Grid.attach(m_AuthL3SwitchKeyEntry, 0, 1);
    m_SL1Grid.attach_next_to(m_SwitchSL3Button, Gtk::PositionType::BOTTOM);
    m_AuthL3SwitchKeyLabel.set_halign(Gtk::Align::START);
    m_AuthL3SwitchKeyEntry.set_hexpand();
    m_SwitchSL3Button.set_halign(Gtk::Align::END);
    m_SwitchSL3Button.signal_clicked().connect(
        sigc::mem_fun(*this, &CMfSecurityLevelDialog::on_button_switch_sl3));

    // Load extra CSS file.
    m_refCssProvider = Gtk::CssProvider::create();
#if HAS_STYLE_PROVIDER_ADD_PROVIDER_FOR_DISPLAY
    Gtk::StyleProvider::add_provider_for_display(get_display(), m_refCssProvider,
                                                 GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#else
    Gtk::StyleContext::add_provider_for_display(get_display(), m_refCssProvider,
                                                GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#endif
    std::string sCSS =
        ".key {"
        "  font-family:monospace; "
        "}";
    m_refCssProvider->load_from_data(sCSS);
    m_MasterKeyEntry.add_css_class("key");
    m_ConfigKeyEntry.add_css_class("key");
    m_L2SwitchKeyEntry.add_css_class("key");
    m_L3SwitchKeyEntry.add_css_class("key");
    m_AuthL3SwitchKeyEntry.add_css_class("key");

    m_oDisp.connect(sigc::mem_fun(*this, &CMfSecurityLevelDialog::on_ilr));

    signal_hide().connect(sigc::mem_fun(*this, &CMfSecurityLevelDialog::on_hide));
}

CMfSecurityLevelDialog::~CMfSecurityLevelDialog() {
}

void ILR_CALL CMfSecurityLevelDialog::on_ilr_message(ilr_reader_msg nMsg, const void* pMsgData,
                                                     void* pUserData) {
    auto p = (CMfSecurityLevelDialog*)pUserData;
    p->m_oDisp.emit();
}

void CMfSecurityLevelDialog::on_ilr() {
    ilr_reader_msg nMsg;
    const void* pMsgData;
    while (m_oReader.GetMessage(nMsg, pMsgData)) {
        if ((ILR_READER_MSG_CARD_FOUND == nMsg) || (ILR_READER_MSG_CARD_LOST == nMsg))
            UpdateCurrentCard();
    }
}

void CMfSecurityLevelDialog::UpdateCurrentCard() {
    m_oReader.GetCardInfo(m_rCardInfo);
    if (m_rCardInfo.rUID.nLength != 0) {
        std::stringstream ss;
        ss << ilr::kCardTypeNames[m_rCardInfo.nType] << ' '
           << ilr::CardUIDToStr(m_rCardInfo.nType, m_rCardInfo.rUID);
        if (m_rCardInfo.nMpType != ILR_MF_PLUS_UNKNOWN)
            ss << ' ' << ilr::kMpTypeNames[m_rCardInfo.nMpType];
        if (m_rCardInfo.nSL != ILR_MF_PLUS_SL_UNKNOWN)
            ss << " SL" << std::dec << (int)m_rCardInfo.nSL;

        m_CardLabel.set_label(ss.str());
    }
    else
        m_CardLabel.set_text("Нет карты");
    UpdateCtrlState();
}

void CMfSecurityLevelDialog::UpdateCtrlState() {
    auto f = (m_rCardInfo.rUID.nLength != 0) && ilr::IsMfPlus(m_rCardInfo.nType) &&
             (ILR_MF_PLUS_SL_SL0 == m_rCardInfo.nSL);
    m_SL1Grid.set_sensitive(f);
    m_SwitchSL1Button.set_sensitive(f);
    if (f) {
        f = (ILR_MF_PLUS_X == m_rCardInfo.nMpType);
        m_L2SwitchKeyLabel.set_visible(f);
        m_L2SwitchKeyEntry.set_visible(f);
    }
    f = (m_rCardInfo.rUID.nLength != 0) && ilr::IsMfPlus(m_rCardInfo.nType) &&
        ((ILR_MF_PLUS_SL_SL1 == m_rCardInfo.nSL) || (ILR_MF_PLUS_SL_SL2 == m_rCardInfo.nSL));
    m_SL1Frame.set_sensitive(f);
    m_SwitchSL3Button.set_sensitive(f);
}

void CMfSecurityLevelDialog::UpdateCtrlData(bool fSave) {
    if (fSave) {
        m_fMasterKeyOk = m_MasterKey.TryParse(m_MasterKeyEntry.get_text().c_str());
        m_fConfigKeyOk = m_ConfigKey.TryParse(m_ConfigKeyEntry.get_text().c_str());
        m_fL2SwitchKeyOk = m_L2SwitchKey.TryParse(m_L2SwitchKeyEntry.get_text().c_str());
        m_fL3SwitchKeyOk = m_L3SwitchKey.TryParse(m_L3SwitchKeyEntry.get_text().c_str());
        m_fAuthL3SwitchKeyOk =
            m_AuthL3SwitchKey.TryParse(m_AuthL3SwitchKeyEntry.get_text().c_str());
    }
    else {
        m_MasterKeyEntry.set_text(m_MasterKey.ToString(" "));
        m_ConfigKeyEntry.set_text(m_ConfigKey.ToString(" "));
        m_L2SwitchKeyEntry.set_text(m_L2SwitchKey.ToString(" "));
        m_L3SwitchKeyEntry.set_text(m_L3SwitchKey.ToString(" "));
        m_AuthL3SwitchKeyEntry.set_text(m_AuthL3SwitchKey.ToString(" "));
    }
}

void CMfSecurityLevelDialog::ShowMessage(const std::string& sMessage, Gtk::MessageType nType) {
    if (nullptr == m_refDialog)
        m_refDialog.reset(new Gtk::MessageDialog("Демо", false, nType));
    m_refDialog->set_transient_for(*this);
    m_refDialog->set_message(sMessage);
    m_refDialog->show();
    m_refDialog->signal_response().connect(
        sigc::bind(sigc::mem_fun(*this, &CMfSecurityLevelDialog::on_dialog_response)));
}

void CMfSecurityLevelDialog::Init(const ilr::CReader& oReader) {
    m_oReader = oReader.Clone();
    m_oReader.EnableMessageQueue();
    m_oReader.SetMessageCallback(&on_ilr_message, this);
    UpdateCurrentCard();
    UpdateCtrlData(false);
}

void CMfSecurityLevelDialog::on_button_card_refresh() {
    m_oReader.Scan(true);
}

void CMfSecurityLevelDialog::on_button_switch_sl1() {
    UpdateCtrlData(true);
    try {
        m_oReader.SetAutoScan(false);
        m_oReader.MfPowerOff();
        std::this_thread::sleep_for(std::chrono::milliseconds(500));
        uint8_t nSak;
        uint16_t nAtq;
        ilr_card_uid rUid;
        if (!m_oReader.MfRas(true, nSak, nAtq, rUid)) {
            ShowMessage("Нет карты.", Gtk::MessageType::ERROR);
            return;
        }
        std::vector<uint8_t> oAts;
        m_oReader.MfRats(oAts);
        m_oReader.MfWritePerso(0x9000, m_MasterKey);
        m_oReader.MfWritePerso(0x9001, m_ConfigKey);
        if (ILR_MF_PLUS_X == m_rCardInfo.nMpType)
            m_oReader.MfWritePerso(0x9002, m_L2SwitchKey);
        m_oReader.MfWritePerso(0x9003, m_L3SwitchKey);
        m_oReader.MfCommitPerso();
    }
    catch (const std::exception& e) {
        // std::cerr << e.what() << '\n';
        ShowMessage(e.what(), Gtk::MessageType::ERROR);
    }
    m_oReader.SetAutoScan(true, false);
}

void CMfSecurityLevelDialog::on_button_switch_sl3() {
    UpdateCtrlData(true);
    try {
        m_oReader.SetAutoScan(false);
        m_oReader.MfPowerOff();
        std::this_thread::sleep_for(std::chrono::milliseconds(500));
        uint8_t nSak;
        uint16_t nAtq;
        ilr_card_uid rUid;
        if (!m_oReader.MfRas(true, nSak, nAtq, rUid)) {
            ShowMessage("Нет карты.", Gtk::MessageType::ERROR);
            return;
        }
        std::vector<uint8_t> oAts;
        m_oReader.MfRats(oAts);
        m_oReader.LoadMfPKey(m_AuthL3SwitchKey);
        m_oReader.AuthMfCard(0x9003, false);
    }
    catch (const std::exception& e) {
        // std::cerr << e.what() << '\n';
        ShowMessage(e.what(), Gtk::MessageType::ERROR);
    }
    m_oReader.SetAutoScan(true, false);
}

void CMfSecurityLevelDialog::on_dialog_response(int) {
    m_refDialog = nullptr;
}

void CMfSecurityLevelDialog::on_hide() {
    m_oReader.Close();
}
