#include "CMfPlusKeysSettings.h"

#include <fstream>

CMfPlusKeysSettings::CMfPlusKeysSettings() :
    m_fModified(false) {
}

void CMfPlusKeysSettings::Load(const std::filesystem::path& path) {
    m_fModified = false;
    m_oKeys.clear();
    if (std::filesystem::exists(path)) {
        std::ifstream inFile;
        inFile.open(path);
        inFile >> std::hex;
        CMpKeyInfo r;
        while (true) {
            inFile >> r.m_Key.ll.hi >> r.m_Key.ll.lo >> std::quoted(r.m_sComment);
            if (!inFile.good())
                break;
            m_oKeys.emplace_back(std::move(r));
        }
    }
}

void CMfPlusKeysSettings::Save(const std::filesystem::path& path) {
    std::ofstream outFile;
    outFile.open(path);
    outFile.imbue(std::locale("C"));
    outFile << std::hex;
    for (auto& r : m_oKeys) {
        outFile << r.m_Key.ll.hi << '\t' << r.m_Key.ll.lo << '\t' << std::quoted(r.m_sComment)
                << std::endl;
    }
    m_fModified = false;
}
