#pragma once
#include <gtkmm.h>

#include "CTemicPasswordsSettings.h"
#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"
#include "types.h"

class CTemicPasswordsDialog : public Gtk::Window {
public:
    CTemicPasswordsDialog();
    ~CTemicPasswordsDialog() override;

    void Init(ilr::CReader& oReader, Glib::RefPtr<CTemicPasswordsSettings> refSettings,
              const int64_t& nCurrentPassword);

protected:
    // A Gio::ListStore item.
    class ModelColumns : public Glib::Object {
    public:
        Glib::Property<int64_t> m_property_password;
        Glib::Property<Glib::ustring> m_property_comment;

        static Glib::RefPtr<ModelColumns> create(int64_t nPassword, const Glib::ustring& sComment) {
            return Glib::make_refptr_for_instance<ModelColumns>(
                new ModelColumns(nPassword, sComment));
        }

    protected:
        ModelColumns(int64_t nPassword, const Glib::ustring& sComment) :
            Glib::ObjectBase(typeid(ModelColumns)),
            m_property_password(*this, "password", nPassword),
            m_property_comment(*this, "comment", sComment) {
        }
    };  // ModelColumns

protected:
    void on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_setup_password(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_setup_comment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_idx(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_password(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_unbind_password(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool password_transform_to(const GValue* a, GValue* b);
    bool password_transform_from(const GValue* a, GValue* b);
    void on_password_label_editing_change(Gtk::ListItem* list_item);
    void on_bind_comment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_unbind_comment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_comment_label_editing_change(Gtk::ListItem* list_item);
    void on_button_sort();
    int on_sort_compare(const Glib::RefPtr<const ModelColumns>& a,
                        const Glib::RefPtr<const ModelColumns>& b);
    void on_button_create();
    void on_button_delete();
    void on_button_cancel();
    void on_button_ok();
    void on_hide();

    void UpdateView();
    void SaveViewData();

public:
    bool m_fAccept;
    int64_t m_nCurrentPassword;

protected:
    ilr::CReader m_oReader;  // Считыватель
    Glib::RefPtr<CTemicPasswordsSettings> m_refSettings;
    bool m_fModifed;

    Gtk::Box m_VBox;

    Gtk::ScrolledWindow m_ScrolledWindow;
    Gtk::ColumnView m_ColumnView;
    Glib::RefPtr<Gio::ListStore<ModelColumns>> m_ListStore;
    Gtk::EditableLabel* m_pNewPasswordLabel;
    Gtk::EditableLabel* m_pCommentLabel;
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;

    Gtk::Box m_BottomBox;        // Нижняя панель с кнопками
    Gtk::Button m_SortButton;    // Кнопка "Сортировать"
    Gtk::Button m_CreateButton;  // Кнопка "Создать"
    Gtk::Button m_DeleteButton;  // Кнопка "Удалить"
    Gtk::Button m_CancelButton;  // Кнопка "Отмена"
    Gtk::Button m_OkButton;      // Кнопка "OK"
};
