#pragma once
#include <filesystem>

#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"
#include "types.h"

class CMifareReaderSettings {
public:
    bool m_fModified;  // true, настройки считывателя изменены
    // Список ключей аутентификации Mifare Classic: А и Б
    CMcKeyInfo m_aMcRdKeys[2][16];
    uint32_t m_aMcValidRdKeys[2];
    uint32_t m_aMcCheckRdKeys[2];

    // Список ключей аутентификации Mifare Plus
    CMpKeyInfo m_aMpRdKeys[2][16];
    uint32_t m_aMpValidRdKeys[2];
    uint32_t m_aMpCheckRdKeys[2];

public:
    CMifareReaderSettings();

    void Load(const std::filesystem::path& path);
    void Save(const std::filesystem::path& path);

    // Ищет ключ в списке ключей Mifare Classic считывателя
    ssize_t FindClassicKey(bool fKeyB, const ilr::CMifareClassicKey& oKey) const;
    // Ищет ключ в списке ключей Mifare Plus считывателя
    ssize_t FindPlusKey(bool fKeyB, const ilr::CMifarePlusKey& oKey) const;

    void SetMcRdKey(size_t nTypeIdx, size_t nKeyIdx, const ilr::CMifareClassicKey& nKey);
    void SetMcRdKeyComment(size_t nTypeIdx, size_t nKeyIdx, const char* pComment);
    void SetMcValidRdKeys(size_t nTypeIdx, uint32_t nValids);
    void SetMcCheckRdKeys(size_t nTypeIdx, uint32_t nChecks);

    void SetMpRdKey(size_t nTypeIdx, size_t nKeyIdx, const ilr::CMifarePlusKey& nKey);
    void SetMpRdKeyComment(size_t nTypeIdx, size_t nKeyIdx, const char* pComment);
    void SetMpValidRdKeys(size_t nTypeIdx, uint32_t nValids);
    void SetMpCheckRdKeys(size_t nTypeIdx, uint32_t nChecks);
};
