#include "CMifareReaderSettings.h"

#include <fstream>

CMifareReaderSettings::CMifareReaderSettings() :
    m_fModified(false) {
    memset(m_aMcValidRdKeys, 0, sizeof(m_aMcValidRdKeys));
    memset(m_aMcCheckRdKeys, 0, sizeof(m_aMcCheckRdKeys));
    memset(m_aMpValidRdKeys, 0, sizeof(m_aMpValidRdKeys));
    memset(m_aMpCheckRdKeys, 0, sizeof(m_aMpCheckRdKeys));
}

void CMifareReaderSettings::Load(const std::filesystem::path& path) {
    m_fModified = false;
    if (std::filesystem::exists(path)) {
        std::ifstream inFile;
        inFile.open(path);
        inFile >> std::hex >> std::boolalpha;

        int nIdx;
        uint64_t nLL;
        bool fChecked, fValidKey;
        for (size_t i = 0; i < std::size(m_aMcRdKeys); i++) {
            for (size_t j = 0; j < std::size(m_aMcRdKeys[i]); j++) {
                auto& key = m_aMcRdKeys[i][j];
                nLL = ilr::CMifareClassicKey::kDefault;
                inFile >> nIdx >> fChecked >> fValidKey >> nLL >> std::quoted(key.m_sComment);
                key.m_Key = nLL;
                SET_BIT(m_aMcValidRdKeys[i], j, fValidKey);
                SET_BIT(m_aMcCheckRdKeys[i], j, fChecked);
            }
        }

        for (size_t i = 0; i < std::size(m_aMpRdKeys); i++) {
            for (size_t j = 0; j < std::size(m_aMpRdKeys[i]); j++) {
                auto& key = m_aMpRdKeys[i][j];
                inFile >> nIdx >> fChecked >> fValidKey >> key.m_Key.ll.hi >> key.m_Key.ll.lo >>
                    std::quoted(key.m_sComment);
                SET_BIT(m_aMpValidRdKeys[i], j, fValidKey);
                SET_BIT(m_aMpCheckRdKeys[i], j, fChecked);
            }
        }
    }
}

void CMifareReaderSettings::Save(const std::filesystem::path& path) {
    std::ofstream outFile;
    outFile.open(path);
    outFile.imbue(std::locale("C"));
    outFile << std::hex << std::boolalpha;

    for (size_t i = 0; i < std::size(m_aMcRdKeys); i++) {
        for (size_t j = 0; j < std::size(m_aMcRdKeys[i]); j++) {
            auto fChecked = GET_BIT(m_aMcCheckRdKeys[i], j);
            auto fValidKey = GET_BIT(m_aMcValidRdKeys[i], j);
            auto& key = m_aMcRdKeys[i][j];
            outFile << std::dec << j << '\t' << fChecked << '\t' << fValidKey << '\t' << std::hex
                    << key.m_Key.m_nKey << '\t' << std::quoted(key.m_sComment) << std::endl;
        }
    }

    for (size_t i = 0; i < std::size(m_aMpRdKeys); i++) {
        for (size_t j = 0; j < std::size(m_aMpRdKeys[i]); j++) {
            auto fChecked = GET_BIT(m_aMpCheckRdKeys[i], j);
            auto fValidKey = GET_BIT(m_aMpValidRdKeys[i], j);
            auto& key = m_aMpRdKeys[i][j];
            outFile << std::dec << j << '\t' << fChecked << '\t' << fValidKey << '\t' << std::hex
                    << key.m_Key.ll.hi << '\t' << key.m_Key.ll.lo << '\t'
                    << std::quoted(key.m_sComment) << std::endl;
        }
    }
    m_fModified = false;
}

ssize_t CMifareReaderSettings::FindClassicKey(bool fKeyB,
                                              const ilr::CMifareClassicKey& oKey) const {
    size_t nTypeIdx = fKeyB ? 1 : 0;
    for (ssize_t i = 0; i < std::size(m_aMcRdKeys[nTypeIdx]); i++)
        if (GET_BIT(m_aMcValidRdKeys[nTypeIdx], i) && (m_aMcRdKeys[nTypeIdx]->m_Key == oKey))
            return i;
    return -1;
}

ssize_t CMifareReaderSettings::FindPlusKey(bool fKeyB, const ilr::CMifarePlusKey& oKey) const {
    size_t nTypeIdx = fKeyB ? 1 : 0;
    for (ssize_t i = 0; i < std::size(m_aMpRdKeys[nTypeIdx]); i++)
        if (GET_BIT(m_aMpValidRdKeys[nTypeIdx], i) && (m_aMpRdKeys[nTypeIdx]->m_Key == oKey))
            return i;
    return -1;
}

void CMifareReaderSettings::SetMcRdKey(size_t nTypeIdx, size_t nKeyIdx,
                                       const ilr::CMifareClassicKey& nKey) {
    auto& rInfo = m_aMcRdKeys[nTypeIdx][nKeyIdx];
    if (rInfo.m_Key == nKey)
        return;
    rInfo.m_Key = nKey;
    m_fModified = true;
}

void CMifareReaderSettings::SetMcRdKeyComment(size_t nTypeIdx, size_t nKeyIdx,
                                              const char* pComment) {
    auto& rInfo = m_aMcRdKeys[nTypeIdx][nKeyIdx];
    if (rInfo.m_sComment == pComment)
        return;
    rInfo.m_sComment = pComment;
    m_fModified = true;
}

void CMifareReaderSettings::SetMcValidRdKeys(size_t nTypeIdx, uint32_t nValids) {
    if (m_aMcValidRdKeys[nTypeIdx] == nValids)
        return;
    m_aMcValidRdKeys[nTypeIdx] = nValids;
    m_fModified = true;
}

void CMifareReaderSettings::SetMcCheckRdKeys(size_t nTypeIdx, uint32_t nChecks) {
    if (m_aMcCheckRdKeys[nTypeIdx] == nChecks)
        return;
    m_aMcCheckRdKeys[nTypeIdx] = nChecks;
    m_fModified = true;
}

void CMifareReaderSettings::SetMpRdKey(size_t nTypeIdx, size_t nKeyIdx,
                                       const ilr::CMifarePlusKey& nKey) {
    auto& rInfo = m_aMpRdKeys[nTypeIdx][nKeyIdx];
    if (rInfo.m_Key == nKey)
        return;
    rInfo.m_Key = nKey;
    m_fModified = true;
}

void CMifareReaderSettings::SetMpRdKeyComment(size_t nTypeIdx, size_t nKeyIdx,
                                              const char* pComment) {
    auto& rInfo = m_aMpRdKeys[nTypeIdx][nKeyIdx];
    if (rInfo.m_sComment == pComment)
        return;
    rInfo.m_sComment = pComment;
    m_fModified = true;
}

void CMifareReaderSettings::SetMpValidRdKeys(size_t nTypeIdx, uint32_t nValids) {
    if (m_aMpValidRdKeys[nTypeIdx] == nValids)
        return;
    m_aMpValidRdKeys[nTypeIdx] = nValids;
    m_fModified = true;
}

void CMifareReaderSettings::SetMpCheckRdKeys(size_t nTypeIdx, uint32_t nChecks) {
    if (m_aMpCheckRdKeys[nTypeIdx] == nChecks)
        return;
    m_aMpCheckRdKeys[nTypeIdx] = nChecks;
    m_fModified = true;
}
