#pragma once
#include <gtkmm.h>

#include "CCardDataGrid.h"
#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"

class CMfUltralightDialog : public Gtk::Window {
public:
    CMfUltralightDialog();
    ~CMfUltralightDialog() override;

    void Init(const ilr::CReader& oReader);

protected:
    uint on_data_get_byte_access(uint nAddress);
    void on_data_validate_byte(uint nAddress, uint8_t& b);
    void on_checkbox_toggle(uint nBlockIdx);
    void on_serial_color_set();
    void on_lock_color_set();
    void on_lock_ro_color_set();
    void on_user_data_color_set();
    void on_user_data_ro_color_set();
    void on_hex_toggled();
    void on_dec_toggled();
    void on_oct_toggled();
    void on_bin_toggled();
    void on_button_read();
    void on_button_write();
    void on_dialog_response(int);
    void on_hide();

    void ReadCardData();
    void UpdateDataGridColors();
    void UpdateDataCheckboxes();
    void SetPageChecked(int nPageIdx, bool fChecked);
    bool CanCheckPage(int nPageIdx) const;
    uint GetByteAccess(uint nAddress) const;
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);

protected:
    ilr::CReader m_oReader;  // Считыватель
    uint8_t m_aOldPages[16][4];
    uint8_t m_aNewPages[16][4];

    Gtk::Box m_VBox;

    Gtk::Box m_DataBox;
    Gtk::ScrolledWindow m_DataScrolledWindow;
    CCardDataGrid m_DataGrid;
    Gtk::Box m_RightBox;
    Gtk::Frame m_LegendFrame;  // Группа "Легенда"
    Gtk::Grid m_LegendGrid;
    Gtk::ColorButton m_SerialButton;      // Кнопка "Серийный номер"
    Gtk::Label m_SerialLabel;             // Метка "Серийный номер"
    Gtk::ColorButton m_LockButton;        // Кнопка "Lock / OTP"
    Gtk::Label m_LockLabel;               // Метка "Lock / OTP"
    Gtk::ColorButton m_LockRoButton;      // Кнопка "Lock / OTP (только чтение)"
    Gtk::Label m_LockRoLabel;             // Метка "Lock / OTP (только чтение)"
    Gtk::ColorButton m_UserDataButton;    // Кнопка "Данные пользователя"
    Gtk::Label m_UserDataLabel;           // Метка "Данные пользователя"
    Gtk::ColorButton m_UserDataRoButton;  // Кнопка "Данные (только чтение)"
    Gtk::Label m_UserDataRoLabel;         // Метка "Данные (только чтение)"
    Gtk::Frame m_FormatFrame;             // Группа "Формат данных"
    Gtk::Box m_FormatBox;
    Gtk::CheckButton m_HexCheckButton;  // Переключатель "Шестнадцатеричный"
    Gtk::CheckButton m_DecCheckButton;  // Переключатель "Десятичный"
    Gtk::CheckButton m_OctCheckButton;  // Переключатель "Восьмеричный"
    Gtk::CheckButton m_BinCheckButton;  // Переключатель "Двоичный"

    Gtk::Box m_BottomBox;       // Нижняя панель с кнопками
    Gtk::Button m_ReadButton;   // Кнопка "Читать"
    Gtk::Button m_WriteButton;  // Кнопка "Записать"
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
};
