#pragma once
#include <gtkmm.h>

#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"

class CMfSecurityLevelDialog : public Gtk::Window {
public:
    CMfSecurityLevelDialog();
    ~CMfSecurityLevelDialog() override;

    void Init(const ilr::CReader& oReader);

protected:
    void on_button_card_refresh();
    void on_button_switch_sl1();
    void on_button_switch_sl3();
    void on_dialog_response(int);
    void on_hide();
    static void ILR_CALL on_ilr_message(ilr_reader_msg nMsg, const void* pMsgData, void* pUserData);
    void on_ilr();

    void UpdateCurrentCard();
    void UpdateCtrlState();
    void UpdateCtrlData(bool fSave);
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);

public:
    ilr::CMifarePlusKey m_MasterKey;
    ilr::CMifarePlusKey m_ConfigKey;
    ilr::CMifarePlusKey m_L2SwitchKey;
    ilr::CMifarePlusKey m_L3SwitchKey;
    ilr::CMifarePlusKey m_AuthL3SwitchKey;

protected:
    ilr::CReader m_oReader;  // Считыватель
    ilr_card_info m_rCardInfo;
    bool m_fMasterKeyOk;
    bool m_fConfigKeyOk;
    bool m_fL2SwitchKeyOk;
    bool m_fL3SwitchKeyOk;
    bool m_fAuthL3SwitchKeyOk;

    Gtk::Box m_VBox;
    Gtk::Frame m_CardFrame;  // Группа "Текущая карта"
    Gtk::Box m_CardBox;
    Gtk::Label m_CardLabel;
    Gtk::Button m_CardRefreshButton;  // Кнопка "Обновить"
    Gtk::Frame m_SL0Frame;  // Группа "Переключение SL0 -> в SL1 или SL3"
    Gtk::Grid m_SL0Grid;
    Gtk::Label m_MasterKeyLabel;  // Метка "Master Key:"
    Gtk::Entry m_MasterKeyEntry;
    Gtk::Label m_ConfigKeyLabel;  // Метка "Configuration Key:"
    Gtk::Entry m_ConfigKeyEntry;
    Gtk::Label m_L2SwitchKeyLabel;  // Метка "Level 2 Switch Key:"
    Gtk::Entry m_L2SwitchKeyEntry;
    Gtk::Label m_L3SwitchKeyLabel;  // Метка "Level 3 Switch Key:"
    Gtk::Entry m_L3SwitchKeyEntry;
    Gtk::Button m_SwitchSL1Button;  // Кнопка "Переключить в SL1"
    Gtk::Frame m_SL1Frame;          // Группа "Переключение SL1 -> в SL3"
    Gtk::Grid m_SL1Grid;
    Gtk::Label m_AuthL3SwitchKeyLabel;  // Метка "Level 3 Switch Key:"
    Gtk::Entry m_AuthL3SwitchKeyEntry;
    Gtk::Button m_SwitchSL3Button;  // Кнопка "Переключить в SL3"
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;

    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Glib::Dispatcher m_oDisp;  // Для синхронизации Callback-функций SDK Readers
};
