#pragma once

#include <gtkmm.h>

#include "CConverterDialog.h"
#include "CProgressDialog.h"
#include "ilguard/ilg_cpp_helpers.h"
#include "ilguard/ilguard.h"

class CMainWindow : public Gtk::Window {
public:
    CMainWindow();
    ~CMainWindow() override;

protected:
    // Signal handlers:
    void on_button_rescan();
    void on_progress_dialog_cancel();
    bool on_progress_dialog_progress(size_t& nCurrent, size_t& nTotal);
    void on_progress_dialog_hide();
    void on_button_open();
    void on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item, Gtk::Align halign);
    void on_bind_port(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_model(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_sn(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_fwversion(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_fwbuild(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_mode(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_selection_changed(guint, guint);
    void on_converter_dialog_hide();
    void on_menu_ilusb();
    void on_menu_tpusb();
    void on_menu_server();
    void on_menu_client();
    void on_menu_showunidentified();
    void on_menu_loglevel(int parameter);
    void on_menu_writelog();
    void on_menu_clearlogatstartup();
    void on_menu_clearlog();
    void on_columnview_rclick(int n_press, double x, double y);
    void on_columnview_activate(guint n);
    void on_form_destroy();
    void on_dialog_response(int);

    static void ILG_CALL on_ilg_log(ilg_log_level nLevel, const char* pContext,
                                    const char* pMessage, void* pUserData);
    static void ILG_CALL on_ilg_message(ilg_search_msg nMsg, const void* pMsgData, void* pUserData);
    void on_ilg();

    void UpdateListView();
    bool DoOpen();
    ilg_port_type GetPortTypeByName(const char* pszPortName);
    void UpdateProperties();
    void UpdateDebugLog();
    void ClearLog();
    std::filesystem::path GetLogFilePath() const;
    void UpdateCvtTypes();
    void ShowMessage(const std::string& sMessage, Gtk::MessageType nType = Gtk::MessageType::INFO);

    // A Gio::ListStore item.
    class ModelColumns : public Glib::Object {
    public:
        ilg_port_type m_nPortType;
        Glib::ustring m_sPortName;
        ilg_converter_model m_nModel;
        int m_nSn;
        uint m_nFwVersion;
        time_t m_tFwBuild;
        ilg_converter_mode m_nMode;

        static Glib::RefPtr<ModelColumns> create(ilg_port_type nPortType,
                                                 const Glib::ustring& sPortName,
                                                 ilg_converter_model nModel, int nSn,
                                                 uint nFwVersion, time_t tFwBuild,
                                                 ilg_converter_mode nMode) {
            return Glib::make_refptr_for_instance<ModelColumns>(
                new ModelColumns(nPortType, sPortName, nModel, nSn, nFwVersion, tFwBuild, nMode));
        }

    protected:
        ModelColumns(ilg_port_type nPortType, const Glib::ustring& sPortName,
                     ilg_converter_model nModel, int nSn, uint nFwVersion, time_t tFwBuild,
                     ilg_converter_mode nMode) :
            m_nPortType(nPortType),
            m_sPortName(sPortName),
            m_nModel(nModel),
            m_nSn(nSn),
            m_nFwVersion(nFwVersion),
            m_tFwBuild(tFwBuild),
            m_nMode(nMode) {
        }
    };  // ModelColumns

    // Child widgets:
    Gtk::Box m_VBox;
    Gtk::ScrolledWindow m_ScrolledWindow;
    Gtk::ColumnView m_ColumnView;
    Gtk::Box m_ButtonBox;
    Gtk::Button m_Button_Rescan;
    Gtk::Entry m_PortEntry;
    Glib::RefPtr<Gtk::StringList> m_refModelStringList;
    Gtk::DropDown m_oModelDropDown;
    Gtk::Button m_Button_Open;
    Gtk::PopoverMenu m_MenuPopup;
    Glib::RefPtr<Gtk::Builder> m_refBuilder;
    Glib::RefPtr<Gtk::GestureClick> m_refRClick;
    Glib::RefPtr<Gio::SimpleAction> m_refILUsbAction;
    Glib::RefPtr<Gio::SimpleAction> m_refTPUsbAction;
    Glib::RefPtr<Gio::SimpleAction> m_refServerAction;
    Glib::RefPtr<Gio::SimpleAction> m_refClientAction;
    Glib::RefPtr<Gio::SimpleAction> m_refShowUnidentifiedAction;
    Glib::RefPtr<Gio::SimpleAction> m_refLogLevelAction;
    Glib::RefPtr<Gio::SimpleAction> m_refWriteLogAction;
    Glib::RefPtr<Gio::SimpleAction> m_refClearLogAtStartupAction;
    Glib::RefPtr<Gtk::MessageDialog> m_refDialog;
    Glib::RefPtr<CProgressDialog> m_refProgressDialog;
    ilg::CAsyncCommand m_oCommand;

    Glib::RefPtr<Gio::ListStore<ModelColumns>> m_ListStore;

    ilg::CILG m_oILG;
    ilg::CConverterSearch m_oSearch;
    CConverterDialog m_oCvtDlg;
    std::filesystem::path m_sLogPath;

    // public:
    Glib::Dispatcher m_oDisp;

    friend void ILG_CALL on_ilg_log(ilg_log_level nLevel, const char* pContext,
                                    const char* pMessage, void* pUserData);
};
