#include "CKeysDialog.h"

#include <iostream>

const char* kKeyTypeAbbrs[] = {"П", "Б", "М"};

CKeysDialog::CKeysDialog() :
    m_fWiegand(false),
    m_nMaxKeys(0),
    m_nBankCount(0),
    m_fScheduleInit(false),
    m_nMode(MODE_UNDEF),
    m_nReadBankIdx(0),
    m_nReadBankCount(0),
    m_aReadCount{0, 0},
    m_InFrame("Вход"),
    m_InBox(Gtk::Orientation::VERTICAL),
    m_InReadButton("Читать все"),
    m_InAddButton("Добавить..."),
    m_InChangeButton("Изменить..."),
    m_InDeleteButton("Удалить"),
    m_InClearButton("Очистить"),
    m_OutFrame("Выход"),
    m_OutBox(Gtk::Orientation::VERTICAL),
    m_OutReadButton("Читать все"),
    m_OutAddButton("Добавить..."),
    m_OutChangeButton("Изменить..."),
    m_OutDeleteButton("Удалить"),
    m_OutClearButton("Очистить") {
    set_destroy_with_parent(true);
    set_title("Ключи");
    set_default_size(600, 480);
    m_Box.set_margin(5);
    set_child(m_Box);
    m_Box.append(m_InFrame);
    m_Box.append(m_OutFrame);
    m_InFrame.set_expand();
    m_OutFrame.set_expand();

    m_InFrame.set_child(m_InBox);
    m_InBox.append(m_InScrolledWindow);

    // Only show the scrollbars when they are necessary:
    m_InScrolledWindow.set_policy(Gtk::PolicyType::AUTOMATIC, Gtk::PolicyType::AUTOMATIC);
    m_InScrolledWindow.set_expand();
    m_InScrolledWindow.set_child(m_InColumnView);
    // Create the List model:
    m_InListStore = Gio::ListStore<ModelColumns>::create();
    // Set list model and selection model.

    auto selection_model = Gtk::MultiSelection::create(m_InListStore);
    m_InColumnView.set_model(selection_model);
    m_InColumnView.add_css_class("data-table");  // high density table
    selection_model->signal_selection_changed().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_in_selection_changed));
    // Make the columns reorderable.
    // This is not necessary, but it's nice to show the feature.
    m_InColumnView.set_reorderable(true);
    m_InColumnView.signal_activate().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_in_columnview_activate));

    // Add the ColumnView's columns:

    // Столбец "№"
    auto factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::END));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_idx));
    auto column = Gtk::ColumnViewColumn::create("№", factory);
    m_InColumnView.append_column(column);

    // Столбец "Номер ключа"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::START));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_key_number));
    column = Gtk::ColumnViewColumn::create("Номер ключа", factory);
    m_InColumnView.append_column(column);

    // Столбец "Тип"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::START));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_type));
    column = Gtk::ColumnViewColumn::create("Тип", factory);
    m_InColumnView.append_column(column);

    // Столбец "Доступ"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::START));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_access));
    column = Gtk::ColumnViewColumn::create("Доступ", factory);
    m_InColumnView.append_column(column);

    // Столбец "Ячейка"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::START));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_cell));
    column = Gtk::ColumnViewColumn::create("Ячейка", factory);
    m_InColumnView.append_column(column);

    m_InBox.append(m_InGrid);
    m_InGrid.set_margin(5);
    m_InGrid.set_row_spacing(10);
    m_InGrid.set_column_spacing(10);
    m_InGrid.attach(m_InReadButton, 0, 0);
    m_InGrid.attach(m_InClearButton, 2, 0);
    m_InGrid.attach(m_InAddButton, 0, 1);
    m_InGrid.attach(m_InChangeButton, 1, 1);
    m_InGrid.attach(m_InDeleteButton, 2, 1);
    // m_InDeleteButton.set_icon_name("list-remove-symbolic");
    // m_InAddButton.set_icon_name("list-add-symbolic");

    m_InReadButton.signal_clicked().connect(sigc::mem_fun(*this, &CKeysDialog::on_button_in_read));
    m_InClearButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_button_in_clear));
    m_InAddButton.signal_clicked().connect(sigc::mem_fun(*this, &CKeysDialog::on_button_in_add));
    m_InChangeButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_button_in_change));
    m_InDeleteButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_button_in_delete));

    m_OutFrame.set_child(m_OutBox);
    m_OutBox.append(m_OutScrolledWindow);

    // Only show the scrollbars when they are necessary:
    m_OutScrolledWindow.set_policy(Gtk::PolicyType::AUTOMATIC, Gtk::PolicyType::AUTOMATIC);
    m_OutScrolledWindow.set_expand();
    m_OutScrolledWindow.set_child(m_OutColumnView);
    // Create the List model:
    m_OutListStore = Gio::ListStore<ModelColumns>::create();
    // Set list model and selection model.
    selection_model = Gtk::MultiSelection::create(m_OutListStore);
    // selection_model->set_autoselect(false);
    // selection_model->set_can_unselect(true);
    m_OutColumnView.set_model(selection_model);
    m_OutColumnView.add_css_class("data-table");  // high density table
    selection_model->signal_selection_changed().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_out_selection_changed));
    // Make the columns reorderable.
    // This is not necessary, but it's nice to show the feature.
    m_OutColumnView.set_reorderable(true);
    m_OutColumnView.signal_activate().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_out_columnview_activate));

    // Add the ColumnView's columns:

    // Столбец "№"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::END));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_idx));
    column = Gtk::ColumnViewColumn::create("№", factory);
    m_OutColumnView.append_column(column);

    // Столбец "Номер ключа"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::START));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_key_number));
    column = Gtk::ColumnViewColumn::create("Номер ключа", factory);
    m_OutColumnView.append_column(column);

    // Столбец "Тип"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::START));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_type));
    column = Gtk::ColumnViewColumn::create("Тип", factory);
    m_OutColumnView.append_column(column);

    // Столбец "Доступ"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::START));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_access));
    column = Gtk::ColumnViewColumn::create("Доступ", factory);
    m_OutColumnView.append_column(column);

    // Столбец "Ячейка"
    factory = Gtk::SignalListItemFactory::create();
    factory->signal_setup().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_setup_label), Gtk::Align::START));
    factory->signal_bind().connect(sigc::mem_fun(*this, &CKeysDialog::on_bind_cell));
    column = Gtk::ColumnViewColumn::create("Ячейка", factory);
    m_OutColumnView.append_column(column);

    m_OutBox.append(m_OutGrid);
    m_OutGrid.set_margin(5);
    m_OutGrid.set_row_spacing(10);
    m_OutGrid.set_column_spacing(10);
    m_OutGrid.attach(m_OutReadButton, 0, 0);
    m_OutGrid.attach(m_OutClearButton, 2, 0);
    m_OutGrid.attach(m_OutAddButton, 0, 1);
    m_OutGrid.attach(m_OutChangeButton, 1, 1);
    m_OutGrid.attach(m_OutDeleteButton, 2, 1);

    m_OutReadButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_button_out_read));
    m_OutClearButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_button_out_clear));
    m_OutAddButton.signal_clicked().connect(sigc::mem_fun(*this, &CKeysDialog::on_button_out_add));
    m_OutChangeButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_button_out_change));
    m_OutDeleteButton.signal_clicked().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_button_out_delete));

    m_oDisp.connect(sigc::mem_fun(*this, &CKeysDialog::on_ilg));

    signal_hide().connect(sigc::mem_fun(*this, &CKeysDialog::on_hide));
}

CKeysDialog::~CKeysDialog() {
    m_oController = nullptr;
}

void CKeysDialog::Init(const ilg::CController& oController) {
    m_oController = oController.Clone();

    ilg_controller_info rInfo;
    m_oController.GetControllerInfo(rInfo);
    auto fTwoBanks = (rInfo.nCtrFlags & ILG_CTR_F_TWOBANKS) != 0;
    m_OutFrame.set_visible(fTwoBanks);
    m_InFrame.set_label(fTwoBanks ? "Вход" : "Вход и выход");
    m_fWiegand = (rInfo.nCtrFlags & ILG_CTR_F_WIEGAND) != 0;
    m_nMaxKeys = (rInfo.nBankSize - 0xC0) / 8;
    if (rInfo.nCtrFlags & ILG_CTR_F_X2)
        m_nMaxKeys += m_nMaxKeys;
    m_nBankCount = (fTwoBanks ? 2 : 1);
    m_oController.EnableMessageQueue();
    m_oController.SetMessageCallback(&on_ilg_message, this);

    UpdateInButtonState();
    if (fTwoBanks)
        UpdateOutButtonState();

    StartReadKeys();
}

void CKeysDialog::on_in_selection_changed(guint position, guint n_items) {
    UpdateInButtonState();
}

void CKeysDialog::on_in_columnview_activate(guint n) {
    auto pModel = dynamic_cast<Gtk::MultiSelection*>(m_InColumnView.get_model().get());
    auto nCount = pModel->get_n_items();
    auto pSelection = pModel->get_selection(0, nCount);
    if (pSelection->get_size() > 1)
        return;
    if (1 == pSelection->get_size())
        DoChangeKey(false, static_cast<int>(*pSelection->cbegin()));
    else
        DoChangeKey(false);
}

void CKeysDialog::on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item, Gtk::Align halign) {
    list_item->set_child(*Gtk::make_managed<Gtk::Label>("", halign));
}

void CKeysDialog::on_bind_idx(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    label->set_text(Glib::ustring::format(list_item->get_position()));
}

void CKeysDialog::on_bind_key_number(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    auto mynum = col->m_property_number.get_value();
    label->set_text(ilg::KeyNumberToStr(mynum.m_Number, mynum.m_nFlags, m_fWiegand));
    Glib::Binding::bind_property_value(col->m_property_number.get_proxy(), label->property_label(),
                                       Glib::Binding::Flags::DEFAULT,
                                       sigc::mem_fun(*this, &CKeysDialog::number_transform_to));
}

bool CKeysDialog::number_transform_to(const GValue* a, GValue* b) {
    auto pSrc = (const MyKeyNumber*)a->data->v_pointer;
    if (b->g_type != G_TYPE_STRING)
        return false;
    g_value_set_string(b, ilg::KeyNumberToStr(pSrc->m_Number, pSrc->m_nFlags, m_fWiegand).c_str());
    return true;
}

void CKeysDialog::on_bind_type(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    label->set_text(kKeyTypeAbbrs[col->m_Type]);
    Glib::Binding::bind_property_value(col->m_Type.get_proxy(), label->property_label(),
                                       Glib::Binding::Flags::DEFAULT,
                                       sigc::mem_fun(*this, &CKeysDialog::type_transform_to));
}

bool CKeysDialog::type_transform_to(const GValue* a, GValue* b) {
    auto pSrc = (const ilg_key_type*)a->data->v_pointer;
    if (b->g_type != G_TYPE_STRING)
        return false;
    g_value_set_static_string(b, kKeyTypeAbbrs[*pSrc]);
    return true;
}

void CKeysDialog::on_bind_access(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    label->set_text(GetAccessStr(col->m_Access));
    Glib::Binding::bind_property_value(col->m_Access.get_proxy(), label->property_label(),
                                       Glib::Binding::Flags::DEFAULT,
                                       sigc::mem_fun(*this, &CKeysDialog::access_transform_to));
}

bool CKeysDialog::access_transform_to(const GValue* a, GValue* b) {
    if (a->g_type != G_TYPE_UCHAR)
        return false;
    auto src = a->data->v_uint;
    if (b->g_type != G_TYPE_STRING)
        return false;
    g_value_set_string(b, GetAccessStr(src));
    return true;
}

void CKeysDialog::on_bind_cell(const Glib::RefPtr<Gtk::ListItem>& list_item) {
    auto col = std::dynamic_pointer_cast<ModelColumns>(list_item->get_item());
    if (!col)
        return;
    auto label = dynamic_cast<Gtk::Label*>(list_item->get_child());
    if (!label)
        return;
    label->set_text(Glib::ustring::format(col->m_Cell));
    Glib::Binding::bind_property(col->m_Cell.get_proxy(), label->property_label());
}

void CKeysDialog::on_button_in_read() {
    StartReadKeys(0);
}

void CKeysDialog::on_button_in_clear() {
    StartClearKeys(0);
}

void CKeysDialog::on_button_in_add() {
    DoChangeKey(false);
}

void CKeysDialog::on_button_in_change() {
    auto pModel = dynamic_cast<Gtk::MultiSelection*>(m_InColumnView.get_model().get());
    auto nCount = pModel->get_n_items();
    auto pSelection = pModel->get_selection(0, nCount);
    if (pSelection->get_size() != 1)
        return;
    DoChangeKey(false, *pSelection->cbegin());
}

void CKeysDialog::on_button_in_delete() {
    auto pModel = dynamic_cast<Gtk::MultiSelection*>(m_InColumnView.get_model().get());
    auto nCount = pModel->get_n_items();
    auto pSelection = pModel->get_selection(0, nCount);
    std::vector<size_t> oIdxs;
    oIdxs.reserve(pSelection->get_size());
    for (auto it = pSelection->cbegin(); it != pSelection->cend(); it++)
        oIdxs.emplace_back(*it);
    m_oController.EraseKeys2(0, oIdxs.data(), oIdxs.size());
    for (auto it = oIdxs.rbegin(); it != oIdxs.rend(); it++)
        m_InListStore->remove(static_cast<guint>(*it));
}

void CKeysDialog::on_out_selection_changed(guint position, guint n_items) {
    UpdateOutButtonState();
}

void CKeysDialog::on_out_columnview_activate(guint n) {
    auto pModel = dynamic_cast<Gtk::MultiSelection*>(m_OutColumnView.get_model().get());
    auto nCount = pModel->get_n_items();
    auto pSelection = pModel->get_selection(0, nCount);
    if (pSelection->get_size() > 1)
        return;
    if (1 == pSelection->get_size())
        DoChangeKey(true, static_cast<int>(*pSelection->cbegin()));
    else
        DoChangeKey(true);
}

void CKeysDialog::on_button_out_read() {
    StartReadKeys(1);
}

void CKeysDialog::on_button_out_clear() {
    StartClearKeys(1);
}

void CKeysDialog::on_button_out_add() {
    DoChangeKey(true);
}

void CKeysDialog::on_button_out_change() {
    auto pModel = dynamic_cast<Gtk::MultiSelection*>(m_OutColumnView.get_model().get());
    auto nCount = pModel->get_n_items();
    auto pSelection = pModel->get_selection(0, nCount);
    if (pSelection->get_size() != 1)
        return;
    DoChangeKey(true, *pSelection->cbegin());
}

void CKeysDialog::on_button_out_delete() {
    auto pModel = dynamic_cast<Gtk::MultiSelection*>(m_OutColumnView.get_model().get());
    auto nCount = pModel->get_n_items();
    auto pSelection = pModel->get_selection(0, nCount);
    std::vector<size_t> oIdxs;
    oIdxs.reserve(pSelection->get_size());
    for (auto it = pSelection->cbegin(); it != pSelection->cend(); it++)
        oIdxs.emplace_back(*it);
    m_oController.EraseKeys2(1, oIdxs.data(), oIdxs.size());
    for (auto it = oIdxs.rbegin(); it != oIdxs.rend(); it++)
        m_OutListStore->remove(static_cast<guint>(*it));
}

void CKeysDialog::on_progress_dialog_cancel() {
    m_oCommand.Cancel();
    m_oCommand = nullptr;
    m_refProgressDialog = nullptr;
}

bool CKeysDialog::on_progress_dialog_progress(size_t& nCurrent, size_t& nTotal) {
    if (1 == m_nReadBankCount)
        m_oCommand.GetProgress(nCurrent, nTotal);
    else {
        size_t c, t;
        m_oCommand.GetProgress(c, t);
        if (1 == m_nReadBankIdx)
            c += m_aReadCount[0];
        nTotal = (m_aReadCount[0] + m_aReadCount[1]);
    }
    return true;
}

void CKeysDialog::on_progress_dialog_hide() {
    m_oCommand = nullptr;
    m_refProgressDialog = nullptr;
}

void CKeysDialog::on_key_dialog_hide() {
    if (m_refKeyDialog->m_fAccept) {
        try {
            m_oController.WriteKeys(m_refKeyDialog->m_fOut ? 1 : 0, m_refKeyDialog->m_nIdx,
                                    &m_refKeyDialog->m_rKey, 1);
            // Обновляем/вставляем элемент списка ColumnView
            // Список должен быть сортирован по возрастанию номеров ячеек m_nCell
            auto& oListStore = (m_refKeyDialog->m_fOut ? m_OutListStore : m_InListStore);
            auto nCount = oListStore->get_n_items();
            auto& key = m_refKeyDialog->m_rKey;
            auto fUpdated = false;
            guint nItemIdx;
            for (guint i = 0; i < nCount; i++) {
                if (m_refKeyDialog->m_nIdx == oListStore->get_item(i)->m_Cell) {
                    auto pItem = oListStore->get_item(i);
                    pItem->SetNumber(key.rNumber, key.nFlags);
                    pItem->m_Type = key.nType;
                    // pItem->m_nFlags = key.nFlags;
                    pItem->m_Access = key.nAccess;
                    nItemIdx = i;
                    fUpdated = true;
                    break;
                }
                else if (m_refKeyDialog->m_nIdx < oListStore->get_item(i)->m_Cell) {
                    nItemIdx = i;
                    oListStore->insert(i, ModelColumns::create(key.rNumber, key.nType, key.nAccess,
                                                               key.nFlags, m_refKeyDialog->m_nIdx));
                    fUpdated = true;
                    break;
                }
            }
            if (!fUpdated) {
                nItemIdx = nCount;
                oListStore->append(ModelColumns::create(key.rNumber, key.nType, key.nAccess,
                                                        key.nFlags, m_refKeyDialog->m_nIdx));
            }

            auto& oColumnView = (m_refKeyDialog->m_fOut ? m_OutColumnView : m_InColumnView);
            auto pModel = dynamic_cast<Gtk::MultiSelection*>(oColumnView.get_model().get());
            pModel->select_item(nItemIdx, true);
        }
        catch (const std::exception& e) {
            ShowMessage(e.what(), Gtk::MessageType::ERROR);
            std::cerr << e.what() << '\n';
        }
    }
    m_refKeyDialog = nullptr;
}

void CKeysDialog::on_hide() {
    m_oController.Close();
}

void ILG_CALL CKeysDialog::on_ilg_message(ilg_controller_msg nMsg, const void* pMsgData,
                                          void* pUserData) {
    auto p = (CKeysDialog*)pUserData;
    p->m_oDisp.emit();
}

void CKeysDialog::on_ilg() {
    ilg_controller_msg nMsg;
    const void* pMsgData;
    while (m_oController.GetMessage(nMsg, pMsgData)) {
        if (ILG_CONTROLLER_MSG_COMMAND_FINISH == nMsg)
            on_ilg_command_finish((ilg_handle)pMsgData);
    }
}

void CKeysDialog::on_ilg_command_finish(ilg_handle hCommand) {
    if (hCommand != m_oCommand.Get())
        return;
    ilg::CAsyncCommand oCommand(std::move(m_oCommand));
    switch (m_nMode) {
    case MODE_READ:
        {
            auto nStatus = oCommand.GetStatus();
            if (ILG_SUCCEEDED(nStatus)) {
                const ilg_key* pList;
                size_t nCount;
                m_oController.End_ReadKeys(oCommand, pList, nCount);

                SetKeys(m_nReadBankIdx, pList, nCount);
                if (++m_nReadBankIdx >= m_nBankCount) {
                    m_refProgressDialog = nullptr;
                    m_nMode = MODE_UNDEF;
                    break;  // Конец
                }
                if (0 == m_aReadCount[m_nReadBankIdx]) {
                    m_refProgressDialog = nullptr;
                    m_nMode = MODE_UNDEF;
                    SetKeys(m_nReadBankIdx, nullptr, 0);
                    break;
                }
                m_oCommand =
                    m_oController.Begin_ReadKeys(m_nReadBankIdx, 0, m_aReadCount[m_nReadBankIdx]);
            }
            else {
                m_refProgressDialog = nullptr;
                m_nMode = MODE_UNDEF;
                ShowMessage(ilg_get_error_text(nStatus), Gtk::MessageType::ERROR);
            }
            break;
        }

    case MODE_CLEAR:
        {
            auto nStatus = oCommand.GetStatus();
            if (ILG_SUCCEEDED(nStatus)) {
                SetKeys(m_nReadBankIdx, nullptr, 0);
                if (++m_nReadBankIdx >= m_nBankCount) {
                    m_refProgressDialog = nullptr;
                    m_nMode = MODE_UNDEF;
                    break;  // Конец
                }
                if (0 == m_aReadCount[m_nReadBankIdx]) {
                    m_refProgressDialog = nullptr;
                    m_nMode = MODE_UNDEF;
                    SetKeys(m_nReadBankIdx, nullptr, 0);
                    break;
                }
                m_oCommand =
                    m_oController.Begin_EraseKeys(m_nReadBankIdx, 0, m_aReadCount[m_nReadBankIdx]);
            }
            else {
                m_refProgressDialog = nullptr;
                m_nMode = MODE_UNDEF;
                ShowMessage(ilg_get_error_text(nStatus), Gtk::MessageType::ERROR);
            }
            break;
        }
    }
}

void CKeysDialog::on_dialog_response(int) {
    m_refDialog = nullptr;
}

void CKeysDialog::StartReadKeys(int nBankN) {
    if (m_oCommand != nullptr) {
        m_oCommand.Cancel();
        m_oCommand = nullptr;
        m_refProgressDialog = nullptr;
    }

    m_nMode = MODE_READ;
    if (nBankN != -1) {
        m_nReadBankIdx = static_cast<uint>(nBankN);
        m_nReadBankCount = 1;
    }
    else {
        m_nReadBankIdx = 0;
        m_nReadBankCount = m_nBankCount;
    }
    for (uint8_t i = 0; i < m_nReadBankCount; i++) {
        auto nTopIdx = m_oController.ReadKeyTopIdx(i);
        m_aReadCount[i] = (nTopIdx != -1) ? static_cast<size_t>(nTopIdx) : m_nMaxKeys;
    }

    while ((m_nReadBankCount != 0) && (0 == m_aReadCount[m_nReadBankIdx])) {
        ++m_nReadBankIdx;
        --m_nReadBankCount;
    }

    if (0 == m_nReadBankCount)
        return;

    m_oCommand = m_oController.Begin_ReadKeys(static_cast<uint8_t>(m_nReadBankIdx), 0,
                                              m_aReadCount[m_nReadBankIdx]);
    m_refProgressDialog.reset(new CProgressDialog());
    m_refProgressDialog->set_transient_for(*this);
    m_refProgressDialog->set_modal();
    m_refProgressDialog->set_hide_on_close();
    m_refProgressDialog->signal_hide().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_progress_dialog_hide));
    m_refProgressDialog->signal_cancel().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_progress_dialog_cancel));
    m_refProgressDialog->signal_progress().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_progress_dialog_progress));
    m_refProgressDialog->SetStatusText("Чтение ключей...");
    m_refProgressDialog->set_visible(true);
}

void CKeysDialog::StartClearKeys(int nBankN) {
    if (m_oCommand != nullptr) {
        m_oCommand.Cancel();
        m_oCommand = nullptr;
        m_refProgressDialog = nullptr;
    }

    m_nMode = MODE_CLEAR;
    if (nBankN != -1) {
        m_nReadBankIdx = static_cast<uint>(nBankN);
        m_nReadBankCount = 1;
    }
    else {
        m_nReadBankIdx = 0;
        m_nReadBankCount = m_nBankCount;
    }
    for (uint8_t i = 0; i < m_nReadBankCount; i++) {
        auto nTopIdx = m_oController.ReadKeyTopIdx(i);
        m_aReadCount[i] = (nTopIdx != -1) ? static_cast<size_t>(nTopIdx) : m_nMaxKeys;
    }

    while ((m_nReadBankCount != 0) && (0 == m_aReadCount[m_nReadBankIdx])) {
        ++m_nReadBankIdx;
        --m_nReadBankCount;
    }

    if (0 == m_nReadBankCount)
        return;

    m_oCommand = m_oController.Begin_EraseKeys(static_cast<uint8_t>(m_nReadBankIdx), 0,
                                               m_aReadCount[m_nReadBankIdx]);
    m_refProgressDialog.reset(new CProgressDialog());
    m_refProgressDialog->set_transient_for(*this);
    m_refProgressDialog->set_modal();
    m_refProgressDialog->set_hide_on_close();
    m_refProgressDialog->signal_hide().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_progress_dialog_hide));
    m_refProgressDialog->signal_cancel().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_progress_dialog_cancel));
    m_refProgressDialog->signal_progress().connect(
        sigc::mem_fun(*this, &CKeysDialog::on_progress_dialog_progress));
    m_refProgressDialog->SetStatusText("Удаление ключей...");
    m_refProgressDialog->set_visible(true);
}

void CKeysDialog::DoChangeKey(bool fOut, int nKeyIdx) {
    if (nullptr == m_refKeyDialog)
        m_refKeyDialog.reset(new CKeyDialog());
    m_refKeyDialog->set_transient_for(*this);
    m_refKeyDialog->set_modal();
    m_refKeyDialog->set_hide_on_close();
    m_refKeyDialog->signal_hide().connect(sigc::mem_fun(*this, &CKeysDialog::on_key_dialog_hide));

    m_refKeyDialog->m_rKey.fErased = false;
    if (nKeyIdx != -1) {
        auto& oListStore = (fOut ? m_OutListStore : m_InListStore);
        auto key = oListStore->get_item(static_cast<guint>(nKeyIdx));
        auto mynum = key->m_property_number.get_value();
        m_refKeyDialog->m_rKey.rNumber = mynum.m_Number;
        m_refKeyDialog->m_rKey.nType = key->m_Type;
        m_refKeyDialog->m_rKey.nFlags = mynum.m_nFlags;
        m_refKeyDialog->m_rKey.nAccess = key->m_Access;
    }
    else {
        // Определяем номер ячейки для нового ключа
        //  (список сортирован по возрастанию номеров ячеек)
        // nKeyIdx
        auto oListStore = (fOut ? m_OutListStore : m_InListStore);
        auto nCount = oListStore->get_n_items();
        auto nNext = 0;
        for (guint i = 0; i < nCount; i++) {
            auto pItem = oListStore->get_item(i);
            if (pItem->m_Cell != nNext) {
                nKeyIdx = nNext;
                break;
            }
            ++nNext;
        }
        if (-1 == nKeyIdx) {
            if (nNext < m_nMaxKeys)
                nKeyIdx = nNext;
            else {
                ShowMessage("Банк ключей заполнен.");
                return;
            }
        }

        // В качестве номера ключа по умолчанию используем последний ключ, поднесенный к считывателю
        ilg_rtc_params rRtc;
        m_oController.ReadRtcParams(rRtc);
        m_refKeyDialog->m_rKey.rNumber = rRtc.rLastKey;
        m_refKeyDialog->m_rKey.nFlags = 0;
        m_refKeyDialog->m_rKey.nType = ILG_KEY_NORMAL;
        m_refKeyDialog->m_rKey.nAccess = 0xff;
    }

    ilg_controller_info rInfo;
    m_oController.GetControllerInfo(rInfo);

    if (!m_fScheduleInit) {
        m_oController.ReadTimeZones(0, 0, m_aTzs[0], std::size(m_aTzs[0]));
        auto fDualZones = (rInfo.nCtrFlags & (ILG_CTR_F_TWOBANKS | ILG_CTR_F_DUALZONE)) != 0;
        if (fDualZones)
            m_oController.ReadTimeZones(1, 0, m_aTzs[1], std::size(m_aTzs[1]));
        m_fScheduleInit = true;
    }
    memcpy(m_refKeyDialog->m_aTzs, m_aTzs, sizeof(m_refKeyDialog->m_aTzs));

    m_refKeyDialog->Init(fOut, nKeyIdx, rInfo.nCtrFlags);

    m_refKeyDialog->set_visible(true);
}

void CKeysDialog::SetKeys(uint nBankIdx, const ilg_key* pList, size_t nCount) {
    auto& oListStore = (1 == nBankIdx) ? m_OutListStore : m_InListStore;
    oListStore->remove_all();
    if (pList != nullptr) {
        size_t nCell = 0;
        auto pEnd = (pList + nCount);
        for (auto p = pList; p != pEnd; p++) {
            if (!p->fErased)
                oListStore->append(
                    ModelColumns::create(p->rNumber, p->nType, p->nAccess, p->nFlags, nCell));
            ++nCell;
        }
    }
}

void CKeysDialog::ShowMessage(const std::string& sMessage, Gtk::MessageType nType) {
    if (nullptr == m_refDialog)
        m_refDialog.reset(new Gtk::MessageDialog("Демо", false, nType));
    m_refDialog->set_transient_for(*this);
    m_refDialog->set_message(sMessage);
    m_refDialog->show();
    m_refDialog->signal_response().connect(
        sigc::bind(sigc::mem_fun(*this, &CKeysDialog::on_dialog_response)));
}

void CKeysDialog::UpdateInButtonState() {
    auto pModel = dynamic_cast<Gtk::MultiSelection*>(m_InColumnView.get_model().get());
    auto nCount = pModel->get_n_items();
    auto selection = pModel->get_selection(0, nCount);
    auto nSelCount = selection->get_size();
    m_InAddButton.set_sensitive(nCount < m_nMaxKeys);
    m_InChangeButton.set_sensitive(1 == nSelCount);
    m_InDeleteButton.set_sensitive(nSelCount != 0);
    m_InClearButton.set_sensitive(nCount != 0);
}

void CKeysDialog::UpdateOutButtonState() {
    auto pModel = dynamic_cast<Gtk::MultiSelection*>(m_OutColumnView.get_model().get());
    auto nCount = pModel->get_n_items();
    auto selection = pModel->get_selection(0, nCount);
    auto nSelCount = selection->get_size();
    m_OutAddButton.set_sensitive(nCount < m_nMaxKeys);
    m_OutChangeButton.set_sensitive(1 == nSelCount);
    m_OutDeleteButton.set_sensitive(nSelCount != 0);
    m_OutClearButton.set_sensitive(nCount != 0);
}

const char* CKeysDialog::GetAccessStr(uint nAccess) {
    switch (nAccess) {
    case 0:
        m_sTemp = "Никогда";
        break;

    case 0xff:
        m_sTemp = "Всегда";
        break;

    default:
        {
            char szDows[8] = {"1234567"};
            for (size_t k = 0; k < 7; k++)
                if (!GET_BIT(nAccess, k))
                    szDows[k] = '-';
            m_sTemp = szDows;
            break;
        }
    }
    return m_sTemp.c_str();
}
