#include "CSecurityDialog.h"

CSecurityDialog::CSecurityDialog() :
    m_nSrcMask(0),
    m_nTime(0),
    m_LoopsCheckButton("Охранный шлейф"),
    m_CoverCheckButton("Снятие крышки контроллера"),
    m_DoorCheckButton("Контроль вскрытия двери"),
    m_TimeLabel("Время звучания сирены после исчезновения источника тревоги (сек):"),
    m_refTimeAdjustment(Gtk::Adjustment::create(0, 0, 255.0)),
    m_ButtonsBox(Gtk::Orientation::VERTICAL),
    m_ReadButton("Читать"),
    m_WriteButton("Записать") {
    set_destroy_with_parent(true);
    set_title("Режим Охрана");
    set_default_size(350, 150);

    set_child(m_Grid);

    m_Grid.set_margin(5);
    m_Grid.set_row_spacing(10);
    m_Grid.set_column_spacing(10);
    m_Grid.attach(m_LoopsCheckButton, 0, 0, 2);
    m_Grid.attach(m_ButtonsBox, 2, 0, 1, 4);
    m_Grid.attach(m_CoverCheckButton, 0, 1, 2);
    m_Grid.attach(m_DoorCheckButton, 0, 2, 2);
    m_Grid.attach(m_TimeLabel, 0, 3);
    m_Grid.attach(m_TimeSpinButton, 1, 3);

    m_TimeLabel.set_wrap_mode(Pango::WrapMode::WORD);
    m_TimeLabel.set_max_width_chars(40);
    m_TimeSpinButton.set_adjustment(m_refTimeAdjustment);

    m_ButtonsBox.set_margin(5);
    m_ButtonsBox.set_spacing(5);
    m_ButtonsBox.append(m_ReadButton);
    m_ButtonsBox.append(m_WriteButton);

    m_ReadButton.signal_clicked().connect(sigc::mem_fun(*this, &CSecurityDialog::on_button_read));
    m_WriteButton.signal_clicked().connect(sigc::mem_fun(*this, &CSecurityDialog::on_button_write));
}

CSecurityDialog::~CSecurityDialog() {
}

void CSecurityDialog::Init(const ilg::CController& oController) {
    m_oController = oController.Clone();
    if (m_oController)
        DoRead();
}

void CSecurityDialog::on_button_read() {
    DoRead();
}

void CSecurityDialog::on_button_write() {
    DoWrite();
}

void CSecurityDialog::DoRead() {
    uint8_t nSrcMask, nTime, nState;
    m_oController.ReadSecurityParams(nSrcMask, nTime, nState);
    m_nSrcMask = nSrcMask;
    m_nTime = nTime;
    UpdateCtrlData(false);
}

void CSecurityDialog::DoWrite() {
    UpdateCtrlData(true);
    m_oController.WriteSecurityParams(static_cast<uint8_t>(m_nSrcMask),
                                      static_cast<uint8_t>(m_nTime));
}

void CSecurityDialog::UpdateCtrlData(bool fSave) {
    if (fSave) {
        SET_BIT(m_nSrcMask, 0, m_LoopsCheckButton.get_active());
        SET_BIT(m_nSrcMask, 1, m_CoverCheckButton.get_active());
        SET_BIT(m_nSrcMask, 2, m_DoorCheckButton.get_active());
        m_nTime = m_TimeSpinButton.get_value_as_int();
    }
    else {
        m_LoopsCheckButton.set_active(GET_BIT(m_nSrcMask, 0));
        m_CoverCheckButton.set_active(GET_BIT(m_nSrcMask, 1));
        m_DoorCheckButton.set_active(GET_BIT(m_nSrcMask, 2));
        m_TimeSpinButton.set_value(m_nTime);
    }
}
