#pragma once
#include "CCardDataGrid.h"
#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"

using byte_format = CCardDataGrid::byte_format;

// Инфо о ключе аутентификации Mifare Classic
class CMcKeyInfo {
public:
    ilr::CMifareClassicKey m_Key;  // Ключ аутентификации
    std::string m_sComment;        // Комментарий
};

using CMcKeyList = std::vector<CMcKeyInfo>;

// Инфо о ключе аутентификации Mifare Plus
class CMpKeyInfo {
public:
    ilr::CMifarePlusKey m_Key;  // Ключ аутентификации
    std::string m_sComment;     // Комментарий
};

using CMpKeyList = std::vector<CMpKeyInfo>;

// Инфо о пароле Temic
class CTemicPassword {
public:
    uint m_nPassword;        // Пароль Temic
    std::string m_sComment;  // Комментарий
};

using CTemicPasswordList = std::vector<CTemicPassword>;
