#pragma once
#include <gtkmm.h>

#include "CMfClassicKeysSettings.h"
#include "CMifareReaderSettings.h"
#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"
#include "types.h"

class CMcKeysDialog : public Gtk::Window {
public:
    CMcKeysDialog();
    ~CMcKeysDialog() override;

    void Init(Glib::RefPtr<CMfClassicKeysSettings> refSets,
              Glib::RefPtr<CMifareReaderSettings> refRdSets);

protected:
    // A Gio::ListStore item.
    class ModelColumns : public Glib::Object {
    public:
        Glib::Property<int64_t> m_property_key;
        Glib::Property<Glib::ustring> m_property_comment;

        static Glib::RefPtr<ModelColumns> create(int64_t nKey, const Glib::ustring& sComment) {
            return Glib::make_refptr_for_instance<ModelColumns>(new ModelColumns(nKey, sComment));
        }

    protected:
        ModelColumns(int64_t nKey, const Glib::ustring& sComment) :
            Glib::ObjectBase(typeid(ModelColumns)),
            m_property_key(*this, "key", nKey),
            m_property_comment(*this, "comment", sComment) {
        }
    };  // ModelColumns

protected:
    void on_setup_label(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_setup_key(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_setup_comment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_idx(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_bind_key(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_unbind_key(const Glib::RefPtr<Gtk::ListItem>& list_item);
    bool key_transform_to(const GValue* a, GValue* b);
    bool key_transform_from(const GValue* a, GValue* b);
    void on_key_label_editing_change(Gtk::ListItem* list_item);
    void on_bind_comment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_unbind_comment(const Glib::RefPtr<Gtk::ListItem>& list_item);
    void on_comment_label_editing_change(Gtk::ListItem* list_item);
    void on_columnview_rclick(int n_press, double x, double y);
    void on_menu_import();
    void on_button_sort();
    int on_sort_compare(const Glib::RefPtr<const ModelColumns>& a,
                        const Glib::RefPtr<const ModelColumns>& b);
    void on_button_create();
    void on_button_delete();
    void on_button_cancel();
    void on_button_ok();

    void UpdateView();
    void SaveViewData();
    guint FindKey(const ilr::CMifareClassicKey& key) const;

public:
    int64_t m_nCurrentKey;
    bool m_fAccept;

protected:
    Glib::RefPtr<CMfClassicKeysSettings> m_refSets;
    Glib::RefPtr<CMifareReaderSettings> m_refRdSets;
    bool m_fModifed;

    Gtk::Box m_VBox;

    Gtk::ScrolledWindow m_ScrolledWindow;
    Gtk::ColumnView m_ColumnView;
    Glib::RefPtr<Gio::ListStore<ModelColumns>> m_ListStore;
    Gtk::EditableLabel* m_pNewKeyLabel;
    Gtk::EditableLabel* m_pCommentLabel;
    Glib::RefPtr<Gtk::CssProvider> m_refCssProvider;
    Glib::RefPtr<Gtk::GestureClick> m_refRClick;
    Gtk::PopoverMenu m_MenuPopup;
    Glib::RefPtr<Gtk::Builder> m_refBuilder;
    // Glib::RefPtr<Gio::SimpleAction> m_refImportAction;

    Gtk::Box m_BottomBox;        // Нижняя панель с кнопками
    Gtk::Button m_SortButton;    // Кнопка "Сортировать"
    Gtk::Button m_CreateButton;  // Кнопка "Создать"
    Gtk::Button m_DeleteButton;  // Кнопка "Удалить"
    Gtk::Button m_CancelButton;  // Кнопка "Отмена"
    Gtk::Button m_OkButton;      // Кнопка "OK"
};
