#pragma once

#include <filesystem>
#include <vector>

#include "ilreaders/ilr_cpp_helpers.h"
#include "ilreaders/ilreaders.h"
#include "types.h"

/** Настройки программы */
class CAppSetings {
protected:
    bool m_fModified;

public:
    bool m_fDebugLog;           // True, писать лог отладки
    bool m_fClearLogAtStartup;  // True, очищать лог при запуске программы
    ilr_log_level m_nLogLevel;  // Уровень лога отладки
    // Настройки поиска считывателей
    uint32_t m_nReaderTypes;  // Типы считывателей для поиска
    bool m_fShowUnidentified;  // True, показывать неопознанные считыватели

    byte_format m_nDataFormat;  // Вид байтов данных карт

    // Настройки цветов легенды в окне "Mifare Ultralight"
    Gdk::RGBA m_MfUlSerialColor;  // Цвет серийного номера
    Gdk::RGBA m_MfUlLockColor;    // Цвет битов блокировки
    Gdk::RGBA m_MfUlLockRoColor;  // Цвет битов блокировки (только чтение)
    Gdk::RGBA m_MfUlUserDataColor;  // Цвет данных пользователя
    Gdk::RGBA m_MfUlUserDataRoColor;  // Цвет данных пользователя (только чтение)

    // Настройки цветов легенды в окне "Temic"
    Gdk::RGBA m_TmcSerialColor;    // Цвет серийного номера
    Gdk::RGBA m_TmcPasswordColor;  // Цвет пароля
    Gdk::RGBA m_TmcUserDataColor;  // Цвет данных пользователя
    Gdk::RGBA m_TmcConfigColor;    // Цвет конфигурации
    // Настройки эмуляции карты в окне "Temic"
    ilr_card_type m_nTmcNewCardType;  // Тип новой эмулируемой карты Temic
    ilr::CCardUID m_rNewEmMarineUid;  // Номер Em-Marine для новой эмулируемой карты Temic
    ilr::CCardUID m_rNewHidUid;  // Номер HID для новой эмулируемой карты Temic

    // Настройки цветов легенды в окне "Mifare Classic"
    Gdk::RGBA m_McSerialColor;    // Цвет серийного номера
    Gdk::RGBA m_McUserDataColor;  // Цвет данных пользователя
    Gdk::RGBA m_McUserDataRoColor;  // Цвет данных пользователя (только чтение)
    Gdk::RGBA m_McValueColor;     // Цвет блока-значение
    Gdk::RGBA m_McValueDtrColor;  // Цвет блока-значение (только Д/П/В)
    Gdk::RGBA m_McNrwDataColor;   // Цвет данных (нельзя читать/писать)
    Gdk::RGBA m_McAccessBitsColor;    // Цвет бит доступа
    Gdk::RGBA m_McAccessBitsRoColor;  // Цвет бит доступа (только чтение)
    Gdk::RGBA m_McKeyColor;           // Цвет ключа аутентификации
    Gdk::RGBA m_McNrwKeyColor;  // Цвет ключа аутентификации (нельзя читать/писать)
    ilr::CMifareClassicKey m_McAuthKey;  // Ключ аутентификации Mifare Classic
    bool m_fMfAuthRdKeys;
    bool m_fMfAuthKeyB;
    bool m_fMfOpenText;
    Gdk::RGBA m_MpEnColor;  // Цвет бит передачи

    // Настройки цветов легенды в окне "Mifare Plus"
    ilr::CMifarePlusKey m_MpAuthKey;  // Ключ аутентификации Mifare Plus

protected:
    std::filesystem::path GetFilePath() const;

public:
    CAppSetings();
    ~CAppSetings();

    void Load();
    void Save();

    bool IsModified() const {
        return m_fModified;
    }

    void SetDebugLog(bool fValue);
    void SetClearLogAtStartup(bool fValue);
    void SetLogLevel(ilr_log_level nValue);
    void SetReaderType(ilr_reader_types nType, bool fSet);
    void SetShowUnidentified(bool fValue);

    void SetDataFormat(byte_format nValue);

    void SetMfUlSerialColor(const Gdk::RGBA& Value);
    void SetMfUlLockColor(const Gdk::RGBA& Value);
    void SetMfUlLockRoColor(const Gdk::RGBA& Value);
    void SetMfUlUserDataColor(const Gdk::RGBA& Value);
    void SetMfUlUserDataRoColor(const Gdk::RGBA& Value);

    void SetTmcSerialColor(const Gdk::RGBA& Value);
    void SetTmcPasswordColor(const Gdk::RGBA& Value);
    void SetTmcUserDataColor(const Gdk::RGBA& Value);
    void SetTmcConfigColor(const Gdk::RGBA& Value);
    void SetTemicNewCardType(ilr_card_type nCardType);
    void SetTemicEmMarineUid(const ilr::CCardUID& rUid);
    void SetTemicHidUid(const ilr::CCardUID& rUid);

    void SetMcSerialColor(const Gdk::RGBA& Value);
    void SetMcUserDataColor(const Gdk::RGBA& Value);
    void SetMcUserDataRoColor(const Gdk::RGBA& Value);
    void SetMcValueColor(const Gdk::RGBA& Value);
    void SetMcValueDtrColor(const Gdk::RGBA& Value);
    void SetMcNrwDataColor(const Gdk::RGBA& Value);
    void SetMcAccessBitsColor(const Gdk::RGBA& Value);
    void SetMcAccessBitsRoColor(const Gdk::RGBA& Value);
    void SetMcKeyColor(const Gdk::RGBA& Value);
    void SetMcNrwKeyColor(const Gdk::RGBA& Value);
    void SetMcAuthKey(const ilr::CMifareClassicKey& Value);
    void SetMfAuthRdKeys(bool fValue);
    void SetMfAuthKeyB(bool fValue);
    void SetMpAuthKey(const ilr::CMifarePlusKey& Value);
    void SetMfOpenText(bool fValue);
    void SetMpEnColor(const Gdk::RGBA& Value);
};

extern CAppSetings g_AppSet;
