#include <iomanip>   // для std::put_time
#include <iostream>  // для std::cout и std::cin

#include "ilr_cpp_helpers.h"
#include "ilreaders.h"

// #define ILR_LOG  // Раскомментируйте, чтобы включить отладочные сообщения
#define ILR_LOG_FILE  // Писать лог в файл

using namespace ilr;

#ifdef ILR_LOG
const char kLogLevelChars[] = {'-', 'E', 'W', 'I', 'D'};
const char kLogFileName[] = "ilreaders.log";  // Путь к лог файлу

void ILR_CALL LogCallback(ilr_log_level level, const char* pContext, const char* pMessage, void*) {
#ifdef ILR_LOG_FILE  // Запись в файл
    std::ofstream file(kLogFileName, std::ios_base::out | std::ios_base::app);
    auto& out = file;
#else  // иначе в консоль
    auto& out = std::cout;
#endif
    auto t = std::time(nullptr);
    auto tmb = std::localtime(&t);
    out << std::put_time(tmb, "%d-%m-%Y %H:%M:%S") << " [" << kLogLevelChars[level] << ' '
        << pContext << "] " << pMessage << std::endl;
}
#endif

int main() {
    std::cout << "Версия SDK: " << SdkVersionToStr(CILR::GetVersion()) << std::endl;

    try {
#ifdef ILR_LOG
#ifdef ILR_LOG_FILE
        // Очищаем лог файл
        std::ofstream file(kLogFileName, std::ios_base::out | std::ios_base::trunc);
        file.close();
#endif
        // Включаем лог отладки
        CILR::SetLogCallback(LogCallback);
        CILR::SetLogLevel(ILR_LOG_LEVEL_DEBUG);
#endif

        CILR oILR;
        CReaderSearch oSearch(oILR.GetSearch());

#if 0
        // Выбираем типы считывателей для поиска
        ilr_search_options rOptions;
        oSearch.GetOptions(rOptions);
        rOptions.nReaderTypes =
            ILR_READER_ILUSB | ILR_READER_CCID | ILR_READER_SERVER | ILR_READER_CLIENT;
        oSearch.SetOptions(rOptions);

        // Включаем поиск считывателей, подключённых к конвертеру в режиме "Клиент"
        const uint16_t aListenPorts[] = {25000};
        oSearch.SetListenPorts(aListenPorts, std::size(aListenPorts));
#endif
        // Ищем считыватели
        std::cout << "Поиск считывателей..." << std::endl;
        oSearch.Scan();
        auto nCount = oSearch.GetReaderCount();
        if (nCount != 0) {
            std::cout << "Найдено " << nCount << ':' << std::endl;
            ilr_reader_info rInfo;
            for (size_t i = 0; i < nCount; i++) {
                oSearch.GetReaderInfo(i, rInfo);
                std::stringstream ss;
                if (rInfo.nModel != ILR_READER_MODEL_UNKNOWN)
                    ss << kReaderModelNames[rInfo.nModel];
                if (rInfo.nSn != -1)
                    ss << " с/н:" << rInfo.nSn;
                if (rInfo.nFwVersion != 0)
                    ss << " прошивка:" << ReaderVersionToStr(rInfo.nFwVersion);
                if (rInfo.nFwBuildDate != 0)
                    ss << " сборка " << TimeToStr(rInfo.nFwBuildDate);
                std::cout << 1 + i << ". " << rInfo.pszPortName << " [" << rInfo.pszConnect
                          << "]: " << ss.str() << std::endl;
            }
        }
        else
            std::cout << "Считыватели не найдены" << std::endl;
    }
    catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }
    return 0;
}
