#pragma once
#include <filesystem>
#include <vector>

#include "types.h"

class CTemicPasswordsSettings {
public:
    bool m_fModified;  // true, настройки изменены
    CTemicPasswordList m_oPasswords;

public:
    CTemicPasswordsSettings();

    void Load(const std::filesystem::path& path);
    void Save(const std::filesystem::path& path);

    inline void SetModifiedFlag(bool fModified = true);
};

inline void CTemicPasswordsSettings::SetModifiedFlag(bool fModified) {
    m_fModified = fModified;
}
